/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.capsd.plugins;

import java.net.InetAddress;
import java.util.Map;
import org.opennms.netmgt.capsd.AbstractPlugin;
import org.opennms.protocols.jmx.connectors.ConnectionWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class JMXPlugin
extends AbstractPlugin {
    private static final Logger LOG = LoggerFactory.getLogger(JMXPlugin.class);
    private String protocolName = null;

    public abstract String getProtocolName(Map<String, Object> var1);

    public abstract ConnectionWrapper getMBeanServerConnection(Map<String, Object> var1, InetAddress var2);

    @Override
    public String getProtocolName() {
        return this.protocolName.toUpperCase();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isProtocolSupported(InetAddress address, Map<String, Object> map) {
        if (this.protocolName == null) {
            this.protocolName = this.getProtocolName(map);
        }
        boolean res = false;
        try (ConnectionWrapper connection = null;){
            connection = this.getMBeanServerConnection(map, address);
            Integer result = connection.getMBeanServer().getMBeanCount();
            LOG.debug("isProtocolSupported? {} {} {}", new Object[]{this.getProtocolName(), result, connection});
            if (result != null) {
                res = true;
            }
        }
        return res;
    }
}

