/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.capsd.plugins;

import java.net.InetAddress;
import java.util.Map;
import org.opennms.core.utils.ParameterMap;
import org.opennms.netmgt.capsd.AbstractPlugin;
import org.opennms.netmgt.icmp.PingerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class IcmpPlugin
extends AbstractPlugin {
    private static final Logger LOG = LoggerFactory.getLogger(IcmpPlugin.class);
    private static final String PROTOCOL_NAME = "ICMP";

    @Override
    public String getProtocolName() {
        return PROTOCOL_NAME;
    }

    @Override
    public boolean isProtocolSupported(InetAddress address) {
        try {
            Number retval = PingerFactory.getInstance().ping(address);
            if (retval != null) {
                return true;
            }
        }
        catch (Throwable e) {
            LOG.warn("Pinger failed to ping {}", (Object)address, (Object)e);
        }
        return false;
    }

    @Override
    public boolean isProtocolSupported(InetAddress address, Map<String, Object> qualifiers) {
        try {
            long timeout;
            int retries;
            if (qualifiers != null) {
                retries = ParameterMap.getKeyedInteger(qualifiers, (String)"retry", (int)2);
                timeout = ParameterMap.getKeyedLong(qualifiers, (String)"timeout", (long)800L);
            } else {
                retries = 2;
                timeout = 800L;
            }
            Number retval = PingerFactory.getInstance().ping(address, timeout, retries);
            if (retval != null) {
                return true;
            }
        }
        catch (Throwable e) {
            LOG.warn("Pinger failed to ping {}", (Object)address, (Object)e);
        }
        return false;
    }
}

