/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.protocols.snmp;

import org.opennms.protocols.snmp.SnmpSyntax;
import org.opennms.protocols.snmp.SnmpUInt32;

public class SnmpTimeTicks
extends SnmpUInt32 {
    static final long serialVersionUID = 5452427494814505218L;
    public static final byte ASNTYPE = 67;

    public SnmpTimeTicks() {
    }

    public SnmpTimeTicks(long value) {
        super(value);
    }

    public SnmpTimeTicks(Long value) {
        super(value);
    }

    public SnmpTimeTicks(SnmpTimeTicks second) {
        super(second);
    }

    public SnmpTimeTicks(SnmpUInt32 uint32) {
        super(uint32);
    }

    public SnmpTimeTicks(String value) {
        super(value);
    }

    @Override
    public byte typeId() {
        return 67;
    }

    @Override
    public SnmpSyntax duplicate() {
        return new SnmpTimeTicks(this);
    }

    @Override
    public Object clone() {
        return new SnmpTimeTicks(this);
    }

    @Override
    public String toString() {
        StringBuffer buf = new StringBuffer();
        long time = this.getValue();
        long tmp = 0L;
        tmp = time / 8640000L;
        if (tmp > 0L) {
            buf.append(tmp).append("d ");
            time %= 8640000L;
        } else {
            buf.append("0d ");
        }
        tmp = time / 360000L;
        if (tmp > 0L) {
            buf.append(tmp).append("h ");
            time %= 360000L;
        } else {
            buf.append("0h ");
        }
        tmp = time / 6000L;
        if (tmp > 0L) {
            buf.append(tmp).append("m ");
            time %= 6000L;
        } else {
            buf.append("0m ");
        }
        tmp = time / 100L;
        if (tmp > 0L) {
            buf.append(tmp).append("s ");
            time %= 100L;
        } else {
            buf.append("0s ");
        }
        buf.append(time * 10L).append("ms");
        return buf.toString();
    }
}

