/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.icmp.jna;

import com.sun.jna.Platform;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import org.opennms.core.logging.Logging;
import org.opennms.jicmp.ipv6.ICMPv6EchoPacket;
import org.opennms.jicmp.ipv6.ICMPv6Packet;
import org.opennms.jicmp.jna.NativeDatagramPacket;
import org.opennms.jicmp.jna.NativeDatagramSocket;
import org.opennms.netmgt.icmp.jna.AbstractPinger;
import org.opennms.netmgt.icmp.jna.V6PingReply;
import org.opennms.netmgt.icmp.jna.V6PingRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class V6Pinger
extends AbstractPinger<Inet6Address> {
    private static final Logger LOG = LoggerFactory.getLogger(V6Pinger.class);

    public V6Pinger(int pingerId) throws Exception {
        super(pingerId, NativeDatagramSocket.create((int)NativeDatagramSocket.PF_INET6, (int)(Platform.isMac() ? NativeDatagramSocket.SOCK_DGRAM : NativeDatagramSocket.SOCK_RAW), (int)58));
        if (Platform.isWindows()) {
            ICMPv6EchoPacket packet = new ICMPv6EchoPacket(64);
            packet.setCode(0);
            packet.setType(ICMPv6Packet.Type.EchoRequest);
            packet.getContentBuffer().putLong(System.nanoTime());
            packet.getContentBuffer().putLong(System.nanoTime());
            this.getPingSocket().send(packet.toDatagramPacket(InetAddress.getByName("::1")));
        }
    }

    @Override
    public void run() {
        Logging.putPrefix((String)"icmp");
        try {
            int pingerId = this.getPingerId();
            NativeDatagramPacket datagram = new NativeDatagramPacket(65535);
            while (!this.isFinished()) {
                this.getPingSocket().receive(datagram);
                long received = System.nanoTime();
                ICMPv6Packet icmpPacket = new ICMPv6Packet(this.getIPPayload(datagram));
                V6PingReply echoReply = icmpPacket.getType() == ICMPv6Packet.Type.EchoReply ? new V6PingReply(icmpPacket, received) : null;
                if (echoReply == null || echoReply.getIdentifier() != pingerId || !echoReply.isValid()) continue;
                this.notifyPingListeners(datagram.getAddress(), echoReply);
            }
        }
        catch (Throwable t) {
            this.setThrowable(t);
            LOG.debug("Error caught while processing ping packets: {}", (Object)t.getMessage(), (Object)t);
        }
    }

    private ByteBuffer getIPPayload(NativeDatagramPacket datagram) {
        return datagram.getContent();
    }

    @Override
    public void ping(Inet6Address addr, int identifier, int sequenceNumber, long threadId, long count, long interval, int packetSize) throws InterruptedException {
        NativeDatagramSocket socket = this.getPingSocket();
        int i = sequenceNumber;
        while ((long)i < (long)sequenceNumber + count) {
            V6PingRequest request = new V6PingRequest(identifier, i, threadId, packetSize);
            request.send(socket, addr);
            Thread.sleep(interval);
            ++i;
        }
    }
}

