/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.icmp.jna;

import com.sun.jna.Platform;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import org.opennms.core.logging.Logging;
import org.opennms.jicmp.ip.ICMPEchoPacket;
import org.opennms.jicmp.ip.ICMPPacket;
import org.opennms.jicmp.ip.IPPacket;
import org.opennms.jicmp.jna.NativeDatagramPacket;
import org.opennms.jicmp.jna.NativeDatagramSocket;
import org.opennms.netmgt.icmp.jna.AbstractPinger;
import org.opennms.netmgt.icmp.jna.V4PingReply;
import org.opennms.netmgt.icmp.jna.V4PingRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class V4Pinger
extends AbstractPinger<Inet4Address> {
    private static final Logger LOG = LoggerFactory.getLogger(V4Pinger.class);

    public V4Pinger(int pingerId) throws Exception {
        super(pingerId, NativeDatagramSocket.create((int)2, (int)(Platform.isMac() ? NativeDatagramSocket.SOCK_DGRAM : NativeDatagramSocket.SOCK_RAW), (int)1));
        if (Platform.isWindows()) {
            ICMPEchoPacket packet = new ICMPEchoPacket(64);
            packet.setCode(0);
            packet.setType(ICMPPacket.Type.EchoRequest);
            packet.getContentBuffer().putLong(System.nanoTime());
            packet.getContentBuffer().putLong(System.nanoTime());
            this.getPingSocket().send(packet.toDatagramPacket(InetAddress.getLocalHost()));
        }
    }

    @Override
    public void run() {
        Logging.putPrefix((String)"icmp");
        try {
            int pingerId = this.getPingerId();
            NativeDatagramPacket datagram = new NativeDatagramPacket(65535);
            while (!this.isFinished()) {
                this.getPingSocket().receive(datagram);
                long received = System.nanoTime();
                ICMPPacket icmpPacket = new ICMPPacket(this.getIPPayload(datagram));
                V4PingReply echoReply = icmpPacket.getType() == ICMPPacket.Type.EchoReply ? new V4PingReply(icmpPacket, received) : null;
                if (echoReply == null || echoReply.getIdentifier() != pingerId || !echoReply.isValid()) continue;
                this.notifyPingListeners(datagram.getAddress(), echoReply);
            }
        }
        catch (Throwable t) {
            this.setThrowable(t);
            LOG.debug("Error caught while processing ping packets: {}", (Object)t.getMessage(), (Object)t);
        }
    }

    private ByteBuffer getIPPayload(NativeDatagramPacket datagram) {
        return new IPPacket(datagram.getContent()).getPayload();
    }

    @Override
    public void ping(Inet4Address addr, int identifier, int sequenceNumber, long threadId, long count, long interval, int packetSize) throws InterruptedException {
        NativeDatagramSocket socket = this.getPingSocket();
        int i = sequenceNumber;
        while ((long)i < (long)sequenceNumber + count) {
            V4PingRequest request = new V4PingRequest(identifier, i, threadId, packetSize);
            request.send(socket, addr);
            Thread.sleep(interval);
            ++i;
        }
    }
}

