/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.transport;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Vector;
import org.snmp4j.SNMP4JSettings;
import org.snmp4j.log.LogAdapter;
import org.snmp4j.log.LogFactory;
import org.snmp4j.smi.Address;
import org.snmp4j.smi.TcpAddress;
import org.snmp4j.transport.AbstractTransportMapping;
import org.snmp4j.transport.ConnectionOrientedTransportMapping;
import org.snmp4j.transport.MessageLengthDecoder;
import org.snmp4j.transport.TransportStateEvent;
import org.snmp4j.transport.TransportStateListener;

public abstract class TcpTransportMapping
extends AbstractTransportMapping
implements ConnectionOrientedTransportMapping {
    private static final LogAdapter logger = LogFactory.getLogger(TcpTransportMapping.class);
    protected TcpAddress tcpAddress;
    private transient Vector transportStateListeners;

    public TcpTransportMapping(TcpAddress tcpAddress) {
        this.tcpAddress = tcpAddress;
    }

    public Class getSupportedAddressClass() {
        return TcpAddress.class;
    }

    public TcpAddress getAddress() {
        return this.tcpAddress;
    }

    public Address getListenAddress() {
        return this.tcpAddress;
    }

    public abstract void sendMessage(Address var1, byte[] var2) throws IOException;

    public abstract void listen() throws IOException;

    public abstract void close() throws IOException;

    public abstract MessageLengthDecoder getMessageLengthDecoder();

    public abstract void setMessageLengthDecoder(MessageLengthDecoder var1);

    public abstract void setConnectionTimeout(long var1);

    public synchronized void addTransportStateListener(TransportStateListener l) {
        if (this.transportStateListeners == null) {
            this.transportStateListeners = new Vector(2);
        }
        this.transportStateListeners.add(l);
    }

    public synchronized void removeTransportStateListener(TransportStateListener l) {
        if (this.transportStateListeners != null) {
            this.transportStateListeners.remove(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireConnectionStateChanged(TransportStateEvent change) {
        block8: {
            Vector listenersFinalRef;
            if (logger.isDebugEnabled()) {
                logger.debug("Firing transport state event: " + change);
            }
            if ((listenersFinalRef = this.transportStateListeners) != null) {
                try {
                    ArrayList listeners;
                    Vector vector = listenersFinalRef;
                    synchronized (vector) {
                        listeners = new ArrayList(listenersFinalRef);
                    }
                    int count = listeners.size();
                    for (int i = 0; i < count; ++i) {
                        ((TransportStateListener)listeners.get(i)).connectionStateChanged(change);
                    }
                }
                catch (RuntimeException rex) {
                    logger.error("Runtime exception in fireConnectionStateChanged:" + rex.getMessage(), rex);
                    if (!SNMP4JSettings.isForwardRuntimeExceptions()) break block8;
                    throw rex;
                }
            }
        }
    }
}

