/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.jicmp.standalone;

import com.sun.jna.Platform;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.util.concurrent.TimeUnit;
import org.opennms.jicmp.ipv6.ICMPv6EchoPacket;
import org.opennms.jicmp.ipv6.ICMPv6Packet;
import org.opennms.jicmp.jna.NativeDatagramPacket;
import org.opennms.jicmp.jna.NativeDatagramSocket;
import org.opennms.jicmp.standalone.AbstractPinger;
import org.opennms.jicmp.standalone.PingReplyListener;
import org.opennms.jicmp.standalone.PingReplyMetric;
import org.opennms.jicmp.standalone.V6PingReply;
import org.opennms.jicmp.standalone.V6PingRequest;

public class V6Pinger
extends AbstractPinger<Inet6Address> {
    public V6Pinger() throws Exception {
        super(NativeDatagramSocket.create(NativeDatagramSocket.PF_INET6, Platform.isMac() ? NativeDatagramSocket.SOCK_DGRAM : NativeDatagramSocket.SOCK_RAW, 58));
        if (Platform.isWindows()) {
            ICMPv6EchoPacket packet = new ICMPv6EchoPacket(64);
            packet.setCode(0);
            packet.setType(ICMPv6Packet.Type.EchoRequest);
            packet.getContentBuffer().putLong(System.nanoTime());
            packet.getContentBuffer().putLong(System.nanoTime());
            this.getPingSocket().send(packet.toDatagramPacket(InetAddress.getByName("::1")));
        }
    }

    @Override
    public void run() {
        try {
            NativeDatagramPacket datagram = new NativeDatagramPacket(65535);
            while (!this.isFinished()) {
                this.getPingSocket().receive(datagram);
                long received = System.nanoTime();
                ICMPv6Packet icmpPacket = new ICMPv6Packet(this.getIPPayload(datagram));
                V6PingReply echoReply = icmpPacket.getType() == ICMPv6Packet.Type.EchoReply ? new V6PingReply(icmpPacket, received) : null;
                if (echoReply == null || !echoReply.isValid()) continue;
                System.out.printf("%d bytes from [%s]: tid=%d icmp_seq=%d time=%.3f ms%n", echoReply.getPacketLength(), datagram.getAddress().getHostAddress(), echoReply.getIdentifier(), echoReply.getSequenceNumber(), echoReply.elapsedTime(TimeUnit.MILLISECONDS));
                for (PingReplyListener listener : this.getListeners()) {
                    listener.onPingReply(datagram.getAddress(), echoReply);
                }
            }
        }
        catch (Throwable e) {
            this.m_throwable.set(e);
            e.printStackTrace();
        }
    }

    private ByteBuffer getIPPayload(NativeDatagramPacket datagram) {
        return datagram.getContent();
    }

    @Override
    public PingReplyMetric ping(Inet6Address addr, int id, int sequenceNumber, int count, long interval) throws InterruptedException {
        PingReplyMetric metric = new PingReplyMetric(count, interval);
        this.addPingReplyListener(metric);
        NativeDatagramSocket socket = this.getPingSocket();
        for (int i = sequenceNumber; i < sequenceNumber + count; ++i) {
            V6PingRequest request = new V6PingRequest(id, i);
            request.send(socket, addr);
            Thread.sleep(interval);
        }
        return metric;
    }
}

