/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.jicmp.standalone;

import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.util.concurrent.TimeUnit;
import org.opennms.jicmp.standalone.PingReplyMetric;
import org.opennms.jicmp.standalone.V4Pinger;
import org.opennms.jicmp.standalone.V6Pinger;

public class Main {
    public static void main(String[] args) throws Exception {
        System.exit(new Main().execute(args));
    }

    public int execute(String[] args) throws Exception {
        PingReplyMetric metric;
        if (args.length < 1) {
            System.err.println("java -jar jna-jicmp-VERSION.jar <hostname or ip address>");
            return 1;
        }
        InetAddress addr = InetAddress.getByName(args[0]);
        if (addr instanceof Inet4Address) {
            V4Pinger pinger = new V4Pinger();
            metric = pinger.ping((Inet4Address)addr);
        } else if (addr instanceof Inet6Address) {
            V6Pinger pinger = new V6Pinger();
            metric = pinger.ping((Inet6Address)addr);
        } else {
            System.err.println("Unrecognized address type " + addr.getClass());
            return 1;
        }
        metric.await();
        System.err.println(metric.getSummary(TimeUnit.MILLISECONDS));
        return 0;
    }
}

