/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.jicmp.jna;

import com.sun.jna.Platform;
import java.net.UnknownHostException;
import org.opennms.jicmp.jna.NativeDatagramPacket;
import org.opennms.jicmp.jna.UnsupportedPlatformException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class NativeDatagramSocket {
    private static final Logger LOG = LoggerFactory.getLogger(NativeDatagramSocket.class);
    public static final int AF_INET = 2;
    public static final int PF_INET = 2;
    public static final int AF_INET6;
    public static final int PF_INET6;
    public static final int SOCK_DGRAM;
    public static final int SOCK_RAW;
    public static final int IPPROTO_ICMP = 1;
    public static final int IPPROTO_UDP = 17;
    public static final int IPPROTO_ICMPV6 = 58;

    public NativeDatagramSocket() {
        if (AF_INET6 == -1) {
            throw new UnsupportedPlatformException(System.getProperty("os.name"));
        }
    }

    public static NativeDatagramSocket create(int family, int type, int protocol) throws Exception {
        String implClassName = NativeDatagramSocket.getImplementationClassName(family);
        LOG.debug("{}({}, {}, {})", new Object[]{implClassName, family, type, protocol});
        Class<NativeDatagramSocket> implementationClass = Class.forName(implClassName).asSubclass(NativeDatagramSocket.class);
        return implementationClass.getDeclaredConstructor(Integer.TYPE, Integer.TYPE, Integer.TYPE).newInstance(family, type, protocol);
    }

    private static String getClassPackage() {
        return NativeDatagramSocket.class.getPackage().getName();
    }

    private static String getClassPrefix() {
        return Platform.isWindows() ? "Win32" : (Platform.isSolaris() ? "Sun" : (Platform.isMac() || Platform.isFreeBSD() || Platform.isOpenBSD() ? "BSD" : "Unix"));
    }

    private static String getFamilyPrefix(int family) {
        if (2 == family) {
            return "V4";
        }
        if (AF_INET6 == family) {
            return "V6";
        }
        throw new IllegalArgumentException("Unsupported Protocol Family: " + family);
    }

    private static String getImplementationClassName(int family) {
        return NativeDatagramSocket.getClassPackage() + "." + NativeDatagramSocket.getClassPrefix() + NativeDatagramSocket.getFamilyPrefix(family) + "NativeSocket";
    }

    public abstract int receive(NativeDatagramPacket var1) throws UnknownHostException;

    public abstract int send(NativeDatagramPacket var1);

    public abstract int close();

    static {
        PF_INET6 = AF_INET6 = Platform.isMac() ? 30 : (Platform.isLinux() ? 10 : (Platform.isWindows() ? 23 : (Platform.isFreeBSD() ? 28 : (Platform.isSolaris() ? 26 : -1))));
        SOCK_DGRAM = Platform.isSolaris() ? 1 : 2;
        SOCK_RAW = Platform.isSolaris() ? 4 : 3;
    }
}

