/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.jicmp.jna;

import com.sun.jna.LastErrorException;
import com.sun.jna.Native;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import org.opennms.jicmp.jna.NativeDatagramPacket;
import org.opennms.jicmp.jna.NativeDatagramSocket;
import org.opennms.jicmp.jna.bsd_sockaddr_in;

public class BSDV4NativeSocket
extends NativeDatagramSocket {
    private int m_sock;

    public BSDV4NativeSocket(int family, int type, int protocol) throws Exception {
        this.m_sock = this.socket(family, type, protocol);
    }

    public native int socket(int var1, int var2, int var3) throws LastErrorException;

    public native int sendto(int var1, Buffer var2, int var3, int var4, bsd_sockaddr_in var5, int var6) throws LastErrorException;

    public native int recvfrom(int var1, Buffer var2, int var3, int var4, bsd_sockaddr_in var5, int[] var6) throws LastErrorException;

    public native int close(int var1) throws LastErrorException;

    private int getSock() {
        return this.m_sock;
    }

    @Override
    public int receive(NativeDatagramPacket p) {
        bsd_sockaddr_in in_addr = new bsd_sockaddr_in();
        int[] szRef = new int[]{in_addr.size()};
        ByteBuffer buf = p.getContent();
        int n = this.recvfrom(this.getSock(), buf, buf.capacity(), 0, in_addr, szRef);
        p.setLength(n);
        p.setAddress(in_addr.getAddress());
        p.setPort(in_addr.getPort());
        return n;
    }

    @Override
    public int send(NativeDatagramPacket p) {
        bsd_sockaddr_in destAddr = new bsd_sockaddr_in(p.getAddress(), p.getPort());
        ByteBuffer buf = p.getContent();
        return this.sendto(this.getSock(), buf, buf.remaining(), 0, destAddr, destAddr.size());
    }

    @Override
    public int close() {
        return this.close(this.getSock());
    }

    static {
        Native.register((String)null);
    }
}

