/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.jicmp.ip;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import org.opennms.jicmp.jna.NativeDatagramPacket;

public class IPPacket {
    private ByteBuffer m_buffer;

    public IPPacket(IPPacket p) {
        this(p.m_buffer.duplicate());
    }

    public IPPacket(ByteBuffer buffer) {
        this.m_buffer = buffer;
    }

    public IPPacket(byte[] data, int offset, int length) {
        this(ByteBuffer.wrap(data, offset, length).slice());
    }

    public IPPacket(NativeDatagramPacket datagram) {
        this(datagram.getContent());
    }

    public int getVersion() {
        return (this.m_buffer.get(0) & 0xF0) >> 4;
    }

    public int getHeaderLength() {
        return (this.m_buffer.get(0) & 0xF) << 2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private InetAddress getAddrAtOffset(int offset) {
        byte[] addr = new byte[4];
        int oldPos = this.m_buffer.position();
        try {
            this.m_buffer.position(offset);
            this.m_buffer.get(addr);
        }
        finally {
            this.m_buffer.position(oldPos);
        }
        InetAddress result = null;
        try {
            result = InetAddress.getByAddress(addr);
        }
        catch (UnknownHostException e) {
            // empty catch block
        }
        return result;
    }

    public int getTimeToLive() {
        return 0xFF & this.m_buffer.get(8);
    }

    public Protocol getProtocol() {
        return Protocol.toProtocol(this.m_buffer.get(9));
    }

    public InetAddress getSourceAddress() {
        return this.getAddrAtOffset(12);
    }

    public InetAddress getDestinationAddress() {
        return this.getAddrAtOffset(16);
    }

    public ByteBuffer getPayload() {
        ByteBuffer data = this.m_buffer.duplicate();
        data.position(this.getHeaderLength());
        return data.slice();
    }

    public int getPayloadLength() {
        return this.getPayload().remaining();
    }

    public static enum Protocol {
        ICMP(1),
        TCP(6),
        UDP(17),
        V6_OVER_V4(41);

        private int m_code;

        private Protocol(int code) {
            this.m_code = code;
        }

        public int getCode() {
            return this.m_code;
        }

        public static Protocol toProtocol(int code) {
            for (Protocol p : Protocol.values()) {
                if (code != p.getCode()) continue;
                return p;
            }
            throw new IllegalArgumentException(String.format("Unabled to find Protocol with code %d", code));
        }
    }
}

