/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.util;

import java.util.List;
import java.util.Random;
import java.util.concurrent.CopyOnWriteArrayList;
import org.restlet.Restlet;
import org.restlet.Route;
import org.restlet.data.Request;
import org.restlet.data.Response;
import org.restlet.util.WrapperList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class RouteList
extends WrapperList<Route> {
    private volatile int lastIndex = -1;

    public RouteList() {
        super(new CopyOnWriteArrayList());
    }

    public RouteList(List<Route> delegate) {
        super(new CopyOnWriteArrayList<Route>(delegate));
    }

    public Route getBest(Request request, Response response, float requiredScore) {
        Route result = null;
        float bestScore = 0.0f;
        for (Route current : this) {
            float score = current.score(request, response);
            if (!(score > bestScore) || !(score >= requiredScore)) continue;
            bestScore = score;
            result = current;
        }
        return result;
    }

    public Route getFirst(Request request, Response response, float requiredScore) {
        for (Route current : this) {
            if (!(current.score(request, response) >= requiredScore)) continue;
            return current;
        }
        return null;
    }

    public synchronized Route getLast(Request request, Response response, float requiredScore) {
        for (int j = this.size() - 1; j >= 0; --j) {
            Route route = (Route)this.get(j);
            if (!(route.score(request, response) >= requiredScore)) continue;
            return route;
        }
        return null;
    }

    public synchronized Route getNext(Request request, Response response, float requiredScore) {
        if (!this.isEmpty()) {
            int initialIndex = this.lastIndex++;
            while (initialIndex != this.lastIndex) {
                Route route;
                if (this.lastIndex >= this.size()) {
                    this.lastIndex = 0;
                }
                if ((route = (Route)this.get(this.lastIndex)).score(request, response) >= requiredScore) {
                    return route;
                }
                ++this.lastIndex;
            }
        }
        return null;
    }

    public synchronized Route getRandom(Request request, Response response, float requiredScore) {
        int length = this.size();
        if (length > 0) {
            int j = new Random().nextInt(length);
            Route route = (Route)this.get(j);
            if (route.score(request, response) >= requiredScore) {
                return route;
            }
            boolean loopedAround = false;
            do {
                if (j == length && !loopedAround) {
                    j = 0;
                    loopedAround = true;
                }
                int n = j++;
                route = (Route)this.get(n);
                if (!(route.score(request, response) >= requiredScore)) continue;
                return route;
            } while (j < length || !loopedAround);
        }
        return null;
    }

    public synchronized void removeAll(Restlet target) {
        for (int i = this.size() - 1; i >= 0; --i) {
            if (((Route)this.get(i)).getNext() != target) continue;
            this.remove(i);
        }
    }

    public RouteList subList(int fromIndex, int toIndex) {
        return new RouteList(this.getDelegate().subList(fromIndex, toIndex));
    }
}

