/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.weaver.tools.cache;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.zip.CRC32;
import org.aspectj.bridge.MessageUtil;
import org.aspectj.util.FileUtil;
import org.aspectj.weaver.tools.cache.CacheBacking;
import org.aspectj.weaver.tools.cache.CacheKeyResolver;
import org.aspectj.weaver.tools.cache.CachedClassEntry;
import org.aspectj.weaver.tools.cache.CachedClassReference;
import org.aspectj.weaver.tools.cache.WeavedClassCache;

public class DefaultFileCacheBacking
implements CacheBacking {
    public static final String WEAVED_CLASS_CACHE_DIR = "aj.weaving.cache.dir";
    public static final String INDEX_FILE = "cache.idx";
    private final File cacheDirectory;
    private final CacheKeyResolver resolver;
    private final HashMap<String, IndexEntry> index = new HashMap();
    private static final Object LOCK = new Object();

    protected DefaultFileCacheBacking(File cacheDirectory, CacheKeyResolver resolver) {
        this.cacheDirectory = cacheDirectory;
        this.resolver = resolver;
        this.readIndex();
    }

    public static CacheBacking createBacking(File cacheDir, CacheKeyResolver resolver) {
        if (!cacheDir.exists() && !cacheDir.mkdirs()) {
            MessageUtil.error("Unable to create cache directory at " + cacheDir.getName());
            return null;
        }
        if (!cacheDir.canWrite()) {
            MessageUtil.error("Cache directory is not writable at " + cacheDir.getName());
            return null;
        }
        return new DefaultFileCacheBacking(cacheDir, resolver);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IndexEntry[] readIndex(File indexFile) {
        IndexEntry[] iea;
        block7: {
            iea = new IndexEntry[]{};
            FileInputStream fis = null;
            ObjectInputStream ois = null;
            try {
                if (!indexFile.canRead()) {
                    IndexEntry[] indexEntryArray = iea;
                    return indexEntryArray;
                }
                fis = new FileInputStream(indexFile);
                ois = new ObjectInputStream(fis);
                iea = (IndexEntry[])ois.readObject();
                DefaultFileCacheBacking.close(fis, indexFile);
            }
            catch (Exception e) {
                DefaultFileCacheBacking.delete(indexFile);
                break block7;
            }
            finally {
                DefaultFileCacheBacking.close(fis, indexFile);
                DefaultFileCacheBacking.close(ois, indexFile);
            }
            DefaultFileCacheBacking.close(ois, indexFile);
        }
        return iea;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readIndex() {
        Object object = LOCK;
        synchronized (object) {
            IndexEntry[] idx;
            for (IndexEntry ie : idx = DefaultFileCacheBacking.readIndex(new File(this.cacheDirectory, INDEX_FILE))) {
                File cacheFile = new File(this.cacheDirectory, ie.key);
                if (!cacheFile.canRead() && !ie.ignored) continue;
                this.index.put(ie.key, ie);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeIndex() {
        Object object = LOCK;
        synchronized (object) {
            if (!this.cacheDirectory.exists()) {
                this.cacheDirectory.mkdirs();
            }
            File indexFile = new File(this.cacheDirectory, INDEX_FILE);
            FileOutputStream fos = null;
            ObjectOutputStream oos = null;
            try {
                DefaultFileCacheBacking.delete(indexFile);
                fos = new FileOutputStream(indexFile);
                oos = new ObjectOutputStream(fos);
                oos.writeObject(this.index.values().toArray(new IndexEntry[0]));
            }
            catch (Exception e) {
                try {
                    throw new RuntimeException(e);
                }
                catch (Throwable throwable) {
                    DefaultFileCacheBacking.close(fos, indexFile);
                    DefaultFileCacheBacking.close(oos, indexFile);
                    throw throwable;
                }
            }
            DefaultFileCacheBacking.close(fos, indexFile);
            DefaultFileCacheBacking.close(oos, indexFile);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeIndexEntry(String key) {
        Object object = LOCK;
        synchronized (object) {
            this.index.remove(key);
            this.writeIndex();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addIndexEntry(IndexEntry ie) {
        Object object = LOCK;
        synchronized (object) {
            this.index.put(ie.key, ie);
            this.writeIndex();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Object object = LOCK;
        synchronized (object) {
            FileUtil.deleteContents(this.cacheDirectory);
        }
    }

    public static CacheBacking createBacking(String scope, CacheKeyResolver resolver) {
        String cache = System.getProperty(WEAVED_CLASS_CACHE_DIR);
        if (cache == null) {
            return null;
        }
        File cacheDir = new File(cache, scope);
        return DefaultFileCacheBacking.createBacking(cacheDir, resolver);
    }

    public String[] getKeys(final String regex) {
        File[] files = this.cacheDirectory.listFiles(new FilenameFilter(){

            public boolean accept(File file, String s) {
                return s.matches(regex);
            }
        });
        if (files == null) {
            return new String[0];
        }
        String[] keys = new String[files.length];
        for (int i = 0; i < files.length; ++i) {
            keys[i] = files[i].getName();
        }
        return keys;
    }

    public CachedClassEntry get(CachedClassReference ref) {
        IndexEntry ie = this.index.get(ref.getKey());
        if (ie != null && ie.ignored) {
            return new CachedClassEntry(ref, WeavedClassCache.ZERO_BYTES, CachedClassEntry.EntryType.IGNORED);
        }
        File cacheFile = new File(this.cacheDirectory, ref.getKey());
        if (cacheFile.canRead()) {
            if (ie == null) {
                DefaultFileCacheBacking.delete(cacheFile);
                return null;
            }
            byte[] bytes = this.read(cacheFile, ie.crc);
            if (bytes != null) {
                if (!ie.generated) {
                    return new CachedClassEntry(ref, bytes, CachedClassEntry.EntryType.WEAVED);
                }
                return new CachedClassEntry(ref, bytes, CachedClassEntry.EntryType.GENERATED);
            }
        }
        return null;
    }

    public void put(CachedClassEntry entry) {
        File cacheFile = new File(this.cacheDirectory, entry.getKey());
        if (!cacheFile.exists()) {
            IndexEntry ie = new IndexEntry();
            ie.key = entry.getKey();
            ie.generated = entry.isGenerated();
            ie.ignored = entry.isIgnored();
            if (!entry.isIgnored()) {
                ie.crc = this.write(cacheFile, entry.getBytes());
            }
            this.addIndexEntry(ie);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(CachedClassReference ref) {
        Object object = LOCK;
        synchronized (object) {
            File cacheFile = new File(this.cacheDirectory, ref.getKey());
            this.removeIndexEntry(ref.getKey());
            DefaultFileCacheBacking.delete(cacheFile);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected byte[] read(File file, long expectedCRC) {
        CRC32 checksum = new CRC32();
        Object object = LOCK;
        synchronized (object) {
            FileInputStream fis = null;
            try {
                fis = new FileInputStream(file);
                byte[] bytes = FileUtil.readAsByteArray(fis);
                checksum.update(bytes);
                if (checksum.getValue() == expectedCRC) {
                    byte[] byArray = bytes;
                    return byArray;
                }
            }
            catch (FileNotFoundException e) {
                MessageUtil.error("File not found " + file.getName());
            }
            catch (IOException e) {
                MessageUtil.error("Error reading cached class " + e.getLocalizedMessage());
            }
            finally {
                DefaultFileCacheBacking.close(fis, file);
            }
            DefaultFileCacheBacking.delete(file);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected long write(File file, byte[] bytes) {
        if (file.exists()) {
            return -1L;
        }
        Object object = LOCK;
        synchronized (object) {
            if (file.exists()) {
                return -1L;
            }
            FileOutputStream out = null;
            Object crcOut = null;
            CRC32 checksum = new CRC32();
            try {
                out = new FileOutputStream(file);
                ((OutputStream)out).write(bytes);
                checksum.update(bytes);
                long l = checksum.getValue();
                return l;
            }
            catch (FileNotFoundException e) {
                MessageUtil.error("Error writing (File Not Found) " + file.getName() + ": " + e.getLocalizedMessage());
            }
            catch (IOException e) {
                MessageUtil.error("Error writing " + file.getName());
            }
            finally {
                DefaultFileCacheBacking.close(out, file);
            }
            DefaultFileCacheBacking.delete(file);
            return -1L;
        }
    }

    protected static void delete(File file) {
        if (file.exists()) {
            file.delete();
        }
    }

    protected static void close(OutputStream out, File file) {
        if (out != null) {
            try {
                out.close();
            }
            catch (IOException e) {
                MessageUtil.error("Error closing write file " + file.getName());
            }
        }
    }

    protected static void close(InputStream in, File file) {
        if (in != null) {
            try {
                in.close();
            }
            catch (IOException e) {
                MessageUtil.error("Error closing read file " + file.getName());
            }
        }
    }

    public static class IndexEntry
    implements Serializable {
        public String key;
        public boolean generated;
        public boolean ignored;
        public long crc;
    }
}

