/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.conversation.impl;

import org.springframework.webflow.context.ExternalContextHolder;
import org.springframework.webflow.conversation.Conversation;
import org.springframework.webflow.conversation.ConversationException;
import org.springframework.webflow.conversation.ConversationId;
import org.springframework.webflow.conversation.ConversationManager;
import org.springframework.webflow.conversation.ConversationParameters;
import org.springframework.webflow.conversation.impl.BadlyFormattedConversationIdException;
import org.springframework.webflow.conversation.impl.ConversationContainer;
import org.springframework.webflow.conversation.impl.ConversationLockFactory;
import org.springframework.webflow.conversation.impl.SimpleConversationId;
import org.springframework.webflow.core.collection.SharedAttributeMap;

public class SessionBindingConversationManager
implements ConversationManager {
    private String sessionKey = "webflowConversationContainer";
    private int maxConversations = 5;
    private ConversationLockFactory conversationLockFactory = new ConversationLockFactory();

    public String getSessionKey() {
        return this.sessionKey;
    }

    public void setSessionKey(String sessionKey) {
        this.sessionKey = sessionKey;
    }

    public int getMaxConversations() {
        return this.maxConversations;
    }

    public void setMaxConversations(int maxConversations) {
        this.maxConversations = maxConversations;
    }

    public int getLockTimeoutSeconds() {
        return this.conversationLockFactory.getTimeoutSeconds();
    }

    public void setLockTimeoutSeconds(int timeoutSeconds) {
        this.conversationLockFactory.setTimeoutSeconds(timeoutSeconds);
    }

    public Conversation beginConversation(ConversationParameters conversationParameters) throws ConversationException {
        return this.getConversationContainer().createConversation(conversationParameters, this.conversationLockFactory);
    }

    public Conversation getConversation(ConversationId id) throws ConversationException {
        return this.getConversationContainer().getConversation(id);
    }

    public ConversationId parseConversationId(String encodedId) throws ConversationException {
        try {
            return new SimpleConversationId(Integer.valueOf(encodedId));
        }
        catch (NumberFormatException e) {
            throw new BadlyFormattedConversationIdException(encodedId, e);
        }
    }

    protected ConversationContainer createConversationContainer() {
        return new ConversationContainer(this.maxConversations, this.sessionKey);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ConversationContainer getConversationContainer() {
        SharedAttributeMap sessionMap = ExternalContextHolder.getExternalContext().getSessionMap();
        Object object = sessionMap.getMutex();
        synchronized (object) {
            ConversationContainer container = (ConversationContainer)sessionMap.get(this.sessionKey);
            if (container == null) {
                container = this.createConversationContainer();
                sessionMap.put(this.sessionKey, container);
            }
            return container;
        }
    }
}

