/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cache.jcache;

import java.util.Collection;
import java.util.LinkedHashSet;
import javax.cache.CacheManager;
import javax.cache.Status;
import org.springframework.cache.Cache;
import org.springframework.cache.jcache.JCacheCache;
import org.springframework.cache.transaction.AbstractTransactionSupportingCacheManager;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JCacheCacheManager
extends AbstractTransactionSupportingCacheManager {
    private CacheManager cacheManager;
    private boolean allowNullValues = true;

    public JCacheCacheManager() {
    }

    public JCacheCacheManager(CacheManager cacheManager) {
        this.cacheManager = cacheManager;
    }

    public void setCacheManager(CacheManager cacheManager) {
        this.cacheManager = cacheManager;
    }

    public CacheManager getCacheManager() {
        return this.cacheManager;
    }

    public void setAllowNullValues(boolean allowNullValues) {
        this.allowNullValues = allowNullValues;
    }

    public boolean isAllowNullValues() {
        return this.allowNullValues;
    }

    protected Collection<Cache> loadCaches() {
        Assert.notNull((Object)this.cacheManager, (String)"A backing CacheManager is required");
        Status status = this.cacheManager.getStatus();
        Assert.isTrue((boolean)Status.STARTED.equals((Object)status), (String)("A 'started' JCache CacheManager is required - current cache is " + status.toString()));
        LinkedHashSet<Cache> caches = new LinkedHashSet<Cache>();
        for (javax.cache.Cache jcache : this.cacheManager.getCaches()) {
            caches.add(new JCacheCache(jcache, this.allowNullValues));
        }
        return caches;
    }

    public Cache getCache(String name) {
        javax.cache.Cache jcache;
        Cache cache = super.getCache(name);
        if (cache == null && (jcache = this.cacheManager.getCache(name)) != null) {
            cache = new JCacheCache(jcache, this.allowNullValues);
            this.addCache(cache);
        }
        return cache;
    }
}

