/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config;

import java.io.File;
import java.io.IOException;
import org.opennms.core.utils.ConfigFileConstants;
import org.opennms.core.xml.JaxbUtils;
import org.opennms.netmgt.config.service.Service;
import org.opennms.netmgt.config.service.ServiceConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ServiceConfigFactory {
    private static final Logger LOG = LoggerFactory.getLogger(ServiceConfigFactory.class);
    private static ServiceConfigFactory m_singleton = null;
    private static boolean m_loaded = false;
    private ServiceConfiguration m_config;

    private ServiceConfigFactory(String configFile) throws IOException {
        this.m_config = (ServiceConfiguration)JaxbUtils.unmarshal(ServiceConfiguration.class, (File)new File(configFile));
    }

    public static synchronized void init() throws IOException {
        if (m_loaded) {
            return;
        }
        File cfgFile = ConfigFileConstants.getFile((int)ConfigFileConstants.SERVICE_CONF_FILE_NAME);
        LOG.debug("ServiceConfigFactory.init: config file path {}", (Object)cfgFile.getPath());
        m_singleton = new ServiceConfigFactory(cfgFile.getPath());
        m_loaded = true;
    }

    public static synchronized void reload() throws IOException {
        m_singleton = null;
        m_loaded = false;
        ServiceConfigFactory.init();
    }

    public static synchronized ServiceConfigFactory getInstance() {
        if (!m_loaded) {
            throw new IllegalStateException("Factory not initialized");
        }
        return m_singleton;
    }

    public static synchronized void setInstance(ServiceConfigFactory instance) {
        m_loaded = true;
        m_singleton = instance;
    }

    public Service[] getServices() {
        int count = this.m_config.getServiceCount();
        Service[] slist = new Service[count];
        count = 0;
        for (Service s : this.m_config.getServiceCollection()) {
            slist[count++] = s;
        }
        return slist;
    }
}

