/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.ValidationException;
import org.opennms.core.utils.ConfigFileConstants;
import org.opennms.core.xml.JaxbUtils;
import org.opennms.netmgt.config.PollOutagesConfigManager;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;

public final class PollOutagesConfigFactory
extends PollOutagesConfigManager {
    private static PollOutagesConfigFactory m_singleton = null;
    private static boolean m_loaded = false;

    PollOutagesConfigFactory(String configFile) {
        this.setConfigResource((Resource)new FileSystemResource(configFile));
    }

    public PollOutagesConfigFactory(Resource resource) {
        this.setConfigResource(resource);
    }

    public static synchronized void init() throws IOException, MarshalException, ValidationException {
        if (m_loaded) {
            return;
        }
        m_singleton = new PollOutagesConfigFactory((Resource)new FileSystemResource(ConfigFileConstants.getFile((int)ConfigFileConstants.POLL_OUTAGES_CONFIG_FILE_NAME)));
        m_singleton.afterPropertiesSet();
        m_loaded = true;
    }

    public static void reload() throws IOException, MarshalException, ValidationException {
        PollOutagesConfigFactory.init();
        PollOutagesConfigFactory.getInstance().update();
    }

    public static PollOutagesConfigFactory getInstance() {
        if (!m_loaded) {
            throw new IllegalStateException("The factory has not been initialized");
        }
        return m_singleton;
    }

    public static void setInstance(PollOutagesConfigFactory instance) {
        m_loaded = true;
        m_singleton = instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveCurrent() throws MarshalException, IOException, ValidationException {
        this.getWriteLock().lock();
        try {
            StringWriter stringWriter = new StringWriter();
            JaxbUtils.marshal((Object)this.getConfig(), (Writer)stringWriter);
            String xmlString = stringWriter.toString();
            if (xmlString != null) {
                this.saveXML(xmlString);
            }
        }
        finally {
            this.getWriteLock().unlock();
        }
        this.update();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void saveXML(String xmlString) throws IOException, MarshalException, ValidationException {
        this.getWriteLock().lock();
        try {
            File cfgFile = ConfigFileConstants.getFile((int)ConfigFileConstants.POLL_OUTAGES_CONFIG_FILE_NAME);
            OutputStreamWriter fileWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(cfgFile), "UTF-8");
            fileWriter.write(xmlString);
            ((Writer)fileWriter).flush();
            ((Writer)fileWriter).close();
        }
        finally {
            this.getWriteLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void update() throws IOException, MarshalException, ValidationException {
        this.getReadLock().lock();
        try {
            this.getContainer().reload();
        }
        finally {
            this.getReadLock().unlock();
        }
    }
}

