/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config;

import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.ValidationException;
import org.opennms.core.utils.ConfigFileConstants;
import org.opennms.core.xml.CastorUtils;
import org.opennms.netmgt.config.categories.CatFactory;
import org.opennms.netmgt.config.categories.Categories;
import org.opennms.netmgt.config.categories.Category;
import org.opennms.netmgt.config.categories.Categorygroup;
import org.opennms.netmgt.config.categories.Catinfo;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;

public final class CategoryFactory
implements CatFactory {
    private final ReadWriteLock m_globalLock = new ReentrantReadWriteLock();
    private final Lock m_readLock = this.m_globalLock.readLock();
    private final Lock m_writeLock = this.m_globalLock.writeLock();
    private static CatFactory m_singleton = null;
    private Catinfo m_config;
    private static boolean m_loaded = false;

    private CategoryFactory(String configFile) throws IOException, MarshalException, ValidationException {
        this((Resource)new FileSystemResource(configFile));
    }

    public CategoryFactory(Resource resource) throws IOException, MarshalException, ValidationException {
        this.m_config = (Catinfo)CastorUtils.unmarshal(Catinfo.class, (Resource)resource);
    }

    public Lock getReadLock() {
        return this.m_readLock;
    }

    public Lock getWriteLock() {
        return this.m_writeLock;
    }

    public static synchronized void init() throws IOException, MarshalException, ValidationException {
        if (m_loaded) {
            return;
        }
        File cfgFile = ConfigFileConstants.getFile((int)ConfigFileConstants.CATEGORIES_CONF_FILE_NAME);
        CategoryFactory.setInstance(new CategoryFactory(cfgFile.getPath()));
    }

    public static synchronized void reload() throws IOException, MarshalException, ValidationException {
        m_singleton = null;
        m_loaded = false;
        CategoryFactory.init();
    }

    public static synchronized CatFactory getInstance() {
        if (!m_loaded) {
            throw new IllegalStateException("The factory has not been initialized");
        }
        return m_singleton;
    }

    public static void setInstance(CatFactory singleton) {
        m_singleton = singleton;
        m_loaded = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Catinfo getConfig() {
        try {
            this.getReadLock().lock();
            Catinfo catinfo = this.m_config;
            return catinfo;
        }
        finally {
            this.getReadLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCategoryGroup(Categorygroup group) {
        try {
            this.getWriteLock().lock();
            this.m_config.addCategorygroup(group);
        }
        finally {
            this.getWriteLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean replaceCategoryGroup(Categorygroup group) {
        try {
            this.getWriteLock().lock();
            String groupname = group.getName();
            for (int i = 0; i < this.m_config.getCategorygroupCount(); ++i) {
                Categorygroup oldCg = this.m_config.getCategorygroup(i);
                if (!oldCg.getName().equals(groupname)) continue;
                this.m_config.setCategorygroup(i, group);
                boolean bl = true;
                return bl;
            }
        }
        finally {
            this.getWriteLock().unlock();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean deleteCategoryGroup(Categorygroup group) {
        try {
            this.getWriteLock().lock();
            boolean bl = this.m_config.removeCategorygroup(group);
            return bl;
        }
        finally {
            this.getWriteLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean deleteCategoryGroup(String groupname) {
        try {
            this.getWriteLock().lock();
            boolean deleted = false;
            Enumeration enumCG = this.m_config.enumerateCategorygroup();
            while (enumCG.hasMoreElements()) {
                Categorygroup cg = (Categorygroup)enumCG.nextElement();
                if (!cg.getName().equals(groupname)) continue;
                deleted = this.m_config.removeCategorygroup(cg);
                break;
            }
            boolean bl = deleted;
            return bl;
        }
        finally {
            this.getWriteLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addCategory(String groupname, Category cat) {
        try {
            this.getWriteLock().lock();
            Enumeration enumCG = this.m_config.enumerateCategorygroup();
            while (enumCG.hasMoreElements()) {
                Categorygroup cg = (Categorygroup)enumCG.nextElement();
                if (!cg.getName().equals(groupname)) continue;
                Categories cats = cg.getCategories();
                cats.addCategory(cat);
                boolean bl = true;
                return bl;
            }
        }
        finally {
            this.getWriteLock().unlock();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean replaceCategory(String groupname, Category cat) {
        try {
            this.getWriteLock().lock();
            Enumeration enumCG = this.m_config.enumerateCategorygroup();
            while (enumCG.hasMoreElements()) {
                Categorygroup cg = (Categorygroup)enumCG.nextElement();
                if (!cg.getName().equals(groupname)) continue;
                String catlabel = cat.getLabel();
                Categories cats = cg.getCategories();
                for (int i = 0; i < cats.getCategoryCount(); ++i) {
                    Category oldCat = cats.getCategory(i);
                    if (!oldCat.getLabel().equals(catlabel)) continue;
                    cats.setCategory(i, cat);
                    boolean bl = true;
                    return bl;
                }
            }
        }
        finally {
            this.getWriteLock().unlock();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean deleteCategory(String groupname, Category cat) {
        try {
            this.getWriteLock().lock();
            Enumeration enumCG = this.m_config.enumerateCategorygroup();
            while (enumCG.hasMoreElements()) {
                Categorygroup cg = (Categorygroup)enumCG.nextElement();
                if (!cg.getName().equals(groupname)) continue;
                Categories cats = cg.getCategories();
                cats.removeCategory(cat);
                boolean bl = true;
                return bl;
            }
        }
        finally {
            this.getWriteLock().unlock();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean deleteCategory(String groupname, String catlabel) {
        try {
            this.getWriteLock().lock();
            Enumeration enumCG = this.m_config.enumerateCategorygroup();
            while (enumCG.hasMoreElements()) {
                Categorygroup cg = (Categorygroup)enumCG.nextElement();
                if (!cg.getName().equals(groupname)) continue;
                Categories cats = cg.getCategories();
                Enumeration enumCat = cats.enumerateCategory();
                while (enumCat.hasMoreElements()) {
                    Category cat = (Category)enumCat.nextElement();
                    if (!cat.getLabel().equals(catlabel)) continue;
                    cats.removeCategory(cat);
                    boolean bl = true;
                    return bl;
                }
            }
        }
        finally {
            this.getWriteLock().unlock();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Category getCategory(String name) {
        try {
            this.getReadLock().lock();
            for (Categorygroup cg : this.m_config.getCategorygroupCollection()) {
                for (Category cat : cg.getCategories().getCategoryCollection()) {
                    if (!cat.getLabel().equals(name)) continue;
                    Category category = cat;
                    return category;
                }
            }
        }
        finally {
            this.getReadLock().unlock();
        }
        return null;
    }

    public double getNormal(String catlabel) {
        Category cat = this.getCategory(catlabel);
        return cat == null ? -1.0 : cat.getNormal();
    }

    public double getWarning(String catlabel) {
        Category cat = this.getCategory(catlabel);
        return cat == null ? -1.0 : cat.getWarning();
    }

    public String[] getServices(String catlabel) {
        Category cat = this.getCategory(catlabel);
        return cat == null ? null : cat.getService();
    }

    public String getRule(String catlabel) {
        Category cat = this.getCategory(catlabel);
        return cat == null ? null : cat.getRule();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getEffectiveRule(String catlabel) {
        try {
            this.getReadLock().lock();
            for (Categorygroup cg : this.m_config.getCategorygroupCollection()) {
                for (Category cat : cg.getCategories().getCategoryCollection()) {
                    if (!cat.getLabel().equals(catlabel)) continue;
                    String string = "(" + cg.getCommon().getRule() + ") & (" + cat.getRule() + ")";
                    return string;
                }
            }
        }
        finally {
            this.getReadLock().unlock();
        }
        return null;
    }
}

