/*
 * Decompiled with CFR 0.152.
 */
package org.asteriskjava.util.internal;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.NoSuchElementException;
import java.util.Scanner;
import java.util.regex.Pattern;
import javax.net.SocketFactory;
import javax.net.ssl.SSLSocketFactory;
import org.asteriskjava.util.SocketConnectionFacade;

public class SocketConnectionFacadeImpl
implements SocketConnectionFacade {
    private Socket socket;
    private Scanner scanner;
    private BufferedWriter writer;
    static final Pattern CRNL_PATTERN = Pattern.compile("\r\n");
    static final Pattern NL_PATTERN = Pattern.compile("\n");

    public SocketConnectionFacadeImpl(String host, int port, boolean ssl, int timeout, int readTimeout) throws IOException {
        Socket socket = ssl ? SSLSocketFactory.getDefault().createSocket() : SocketFactory.getDefault().createSocket();
        socket.setSoTimeout(readTimeout);
        socket.connect(new InetSocketAddress(host, port), timeout);
        this.initialize(socket, CRNL_PATTERN);
    }

    SocketConnectionFacadeImpl(Socket socket) throws IOException {
        this.initialize(socket, NL_PATTERN);
    }

    private void initialize(Socket socket, Pattern pattern) throws IOException {
        this.socket = socket;
        InputStream inputStream = socket.getInputStream();
        OutputStream outputStream = socket.getOutputStream();
        BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));
        this.scanner = new Scanner(reader);
        this.scanner.useDelimiter(pattern);
        this.writer = new BufferedWriter(new OutputStreamWriter(outputStream));
    }

    public String readLine() throws IOException {
        try {
            return this.scanner.next();
        }
        catch (IllegalStateException e) {
            if (this.scanner.ioException() != null) {
                throw this.scanner.ioException();
            }
            throw new IOException("No more lines available: " + e.getMessage());
        }
        catch (NoSuchElementException e) {
            if (this.scanner.ioException() != null) {
                throw this.scanner.ioException();
            }
            throw new IOException("No more lines available: " + e.getMessage());
        }
    }

    public void write(String s) throws IOException {
        this.writer.write(s);
    }

    public void flush() throws IOException {
        this.writer.flush();
    }

    public void close() throws IOException {
        this.socket.close();
        this.scanner.close();
    }

    public boolean isConnected() {
        return this.socket.isConnected();
    }

    public InetAddress getLocalAddress() {
        return this.socket.getLocalAddress();
    }

    public int getLocalPort() {
        return this.socket.getLocalPort();
    }

    public InetAddress getRemoteAddress() {
        return this.socket.getInetAddress();
    }

    public int getRemotePort() {
        return this.socket.getPort();
    }
}

