/*
 * Decompiled with CFR 0.152.
 */
package org.asteriskjava.util;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReflectionUtil {
    private ReflectionUtil() {
    }

    public static Map<String, Method> getGetters(Class clazz) {
        Method[] methods;
        HashMap<String, Method> accessors = new HashMap<String, Method>();
        for (Method method : methods = clazz.getMethods()) {
            String name;
            String methodName = method.getName();
            if (!methodName.startsWith("get") || method.getParameterTypes().length != 0 || (name = methodName.substring("get".length()).toLowerCase(Locale.ENGLISH)).length() == 0) continue;
            accessors.put(name, method);
        }
        return accessors;
    }

    public static Map<String, Method> getSetters(Class clazz) {
        Method[] methods;
        HashMap<String, Method> accessors = new HashMap<String, Method>();
        for (Method method : methods = clazz.getMethods()) {
            String methodName = method.getName();
            if (!methodName.startsWith("set") || method.getParameterTypes().length != 1) continue;
            String name = methodName.substring("set".length()).toLowerCase(Locale.US);
            accessors.put(name, method);
        }
        return accessors;
    }

    public static String stripIllegalCharacters(String s) {
        char c;
        int i;
        boolean needsStrip = false;
        if (s == null) {
            return null;
        }
        for (i = 0; i < s.length(); ++i) {
            c = s.charAt(i);
            if (c >= '0' && c <= '9' || c >= 'a' && c <= 'z') continue;
            needsStrip = true;
            break;
        }
        if (!needsStrip) {
            return s;
        }
        StringBuffer sb = new StringBuffer(s.length());
        for (i = 0; i < s.length(); ++i) {
            c = s.charAt(i);
            if (c >= '0' && c <= '9') {
                sb.append(c);
                continue;
            }
            if (c < 'a' || c > 'z') continue;
            sb.append(c);
        }
        return sb.toString();
    }
}

