/*
 * Decompiled with CFR 0.152.
 */
package org.asteriskjava.util;

import org.asteriskjava.util.Log;
import org.asteriskjava.util.internal.JavaLoggingLog;
import org.asteriskjava.util.internal.Log4JLogger;
import org.asteriskjava.util.internal.NullLog;

public final class LogFactory {
    private static Boolean log4jLoggingAvailable = null;
    private static Boolean javaLoggingAvailable = null;

    public static Log getLog(Class clazz) {
        if (log4jLoggingAvailable == null) {
            try {
                Class.forName("org.apache.log4j.Logger");
                log4jLoggingAvailable = Boolean.TRUE;
            }
            catch (Exception e) {
                log4jLoggingAvailable = Boolean.FALSE;
            }
        }
        if (log4jLoggingAvailable.booleanValue()) {
            return new Log4JLogger(clazz);
        }
        if (javaLoggingAvailable == null) {
            try {
                Class.forName("java.util.logging.Logger");
                javaLoggingAvailable = Boolean.TRUE;
            }
            catch (Exception e) {
                javaLoggingAvailable = Boolean.FALSE;
            }
        }
        if (javaLoggingAvailable.booleanValue()) {
            return new JavaLoggingLog(clazz);
        }
        return new NullLog();
    }
}

