/*
 * Decompiled with CFR 0.152.
 */
package org.asteriskjava.fastagi.command;

import org.asteriskjava.fastagi.command.AbstractAgiCommand;

public class ControlStreamFileCommand
extends AbstractAgiCommand {
    private static final long serialVersionUID = 3978141041352128820L;
    private String file;
    private String escapeDigits;
    private int offset;
    private String forwardDigit;
    private String rewindDigit;
    private String pauseDigit;

    public ControlStreamFileCommand(String file) {
        this.file = file;
        this.offset = -1;
    }

    public ControlStreamFileCommand(String file, String escapeDigits) {
        this.file = file;
        this.escapeDigits = escapeDigits;
        this.offset = -1;
    }

    public ControlStreamFileCommand(String file, String escapeDigits, int offset) {
        this.file = file;
        this.escapeDigits = escapeDigits;
        this.offset = offset;
    }

    public ControlStreamFileCommand(String file, String escapeDigits, int offset, String forwardDigit, String rewindDigit, String pauseDigit) {
        this.file = file;
        this.escapeDigits = escapeDigits;
        this.offset = offset;
        this.forwardDigit = forwardDigit;
        this.rewindDigit = rewindDigit;
        this.pauseDigit = pauseDigit;
    }

    public String getFile() {
        return this.file;
    }

    public void setFile(String file) {
        this.file = file;
    }

    public String getEscapeDigits() {
        return this.escapeDigits;
    }

    public void setEscapeDigits(String escapeDigits) {
        this.escapeDigits = escapeDigits;
    }

    public int getOffset() {
        return this.offset;
    }

    public void setOffset(int offset) {
        this.offset = offset;
    }

    public String getForwardDigit() {
        return this.forwardDigit;
    }

    public String getRewindDigit() {
        return this.rewindDigit;
    }

    public String getPauseDigit() {
        return this.pauseDigit;
    }

    public void setControlDigits(String forwardDigit, String rewindDigit) {
        this.forwardDigit = forwardDigit;
        this.rewindDigit = rewindDigit;
    }

    public void setControlDigits(String forwardDigit, String rewindDigit, String pauseDigit) {
        this.forwardDigit = forwardDigit;
        this.rewindDigit = rewindDigit;
        this.pauseDigit = pauseDigit;
    }

    public String buildCommand() {
        StringBuffer sb = new StringBuffer("CONTROL STREAM FILE ");
        sb.append(this.escapeAndQuote(this.file));
        sb.append(" ");
        sb.append(this.escapeAndQuote(this.escapeDigits));
        if (this.offset >= 0) {
            sb.append(" ");
            sb.append(this.offset);
        } else if (this.forwardDigit != null || this.rewindDigit != null || this.pauseDigit != null) {
            sb.append(" 0");
        }
        if (this.forwardDigit != null || this.rewindDigit != null || this.pauseDigit != null) {
            sb.append(" ");
            sb.append(this.forwardDigit);
        }
        if (this.rewindDigit != null || this.pauseDigit != null) {
            sb.append(" ");
            sb.append(this.rewindDigit);
        }
        if (this.pauseDigit != null) {
            sb.append(" ");
            sb.append(this.pauseDigit);
        }
        return sb.toString();
    }
}

