/*
 * Decompiled with CFR 0.152.
 */
package org.asteriskjava.fastagi;

import java.lang.reflect.Constructor;
import org.asteriskjava.fastagi.AgiScript;
import org.asteriskjava.fastagi.MappingStrategy;
import org.asteriskjava.util.Log;
import org.asteriskjava.util.LogFactory;

public abstract class AbstractMappingStrategy
implements MappingStrategy {
    protected Log logger = LogFactory.getLog(this.getClass());

    protected ClassLoader getClassLoader() {
        return Thread.currentThread().getContextClassLoader();
    }

    protected AgiScript createAgiScriptInstance(String className) {
        Class<?> tmpClass;
        AgiScript agiScript = null;
        try {
            tmpClass = this.getClassLoader().loadClass(className);
        }
        catch (ClassNotFoundException e1) {
            this.logger.error("Unable to create AgiScript instance of type " + className + ": Class not found, make sure the class exists and is available on the CLASSPATH");
            return null;
        }
        if (!AgiScript.class.isAssignableFrom(tmpClass)) {
            this.logger.error("Unable to create AgiScript instance of type " + className + ": Class does not implement the AgiScript interface");
            return null;
        }
        Class<?> agiScriptClass = tmpClass;
        try {
            Constructor<?> constructor = agiScriptClass.getConstructor(new Class[0]);
            agiScript = (AgiScript)constructor.newInstance(new Object[0]);
        }
        catch (Exception e) {
            this.logger.error("Unable to create AgiScript instance of type " + className, e);
        }
        return agiScript;
    }
}

