/*
 * Decompiled with CFR 0.152.
 */
package org.asteriskjava.fastagi;

import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.asteriskjava.fastagi.MappingStrategy;
import org.asteriskjava.util.DaemonThreadFactory;
import org.asteriskjava.util.Log;
import org.asteriskjava.util.LogFactory;

public abstract class AbstractAgiServer {
    private final Log logger = LogFactory.getLog(this.getClass());
    private static final int DEFAULT_POOL_SIZE = 10;
    private static final int DEFAULT_MAXIMUM_POOL_SIZE = 100;
    private int poolSize = 10;
    private int maximumPoolSize = 100;
    private ThreadPoolExecutor pool;
    private MappingStrategy mappingStrategy;
    private volatile boolean die = false;

    public void setPoolSize(int poolSize) {
        this.poolSize = poolSize;
    }

    public void setMaximumPoolSize(int maximumPoolSize) {
        this.maximumPoolSize = maximumPoolSize;
    }

    public void setMappingStrategy(MappingStrategy mappingStrategy) {
        this.mappingStrategy = mappingStrategy;
    }

    protected MappingStrategy getMappingStrategy() {
        return this.mappingStrategy;
    }

    protected boolean isDie() {
        return this.die;
    }

    protected synchronized void shutdown() {
        this.die = true;
        if (this.pool != null) {
            this.pool.shutdown();
        }
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.die = true;
        if (this.pool != null) {
            this.pool.shutdown();
        }
    }

    protected void execute(Runnable command) {
        if (this.isDie()) {
            this.logger.warn("AgiServer is shutting down: Refused to execute AgiScript");
            return;
        }
        this.getPool().execute(command);
    }

    private synchronized ThreadPoolExecutor getPool() {
        if (this.pool == null) {
            this.pool = this.createPool();
            this.logger.info("Thread pool started.");
        }
        return this.pool;
    }

    protected ThreadPoolExecutor createPool() {
        return new ThreadPoolExecutor(this.poolSize, this.maximumPoolSize < this.poolSize ? this.poolSize : this.maximumPoolSize, 50000L, TimeUnit.MILLISECONDS, new SynchronousQueue<Runnable>(), new DaemonThreadFactory());
    }
}

