/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.layout;

import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginFactory;
import org.apache.logging.log4j.core.layout.AbstractJacksonLayout;
import org.apache.logging.log4j.core.layout.JacksonFactory;
import org.apache.logging.log4j.core.util.Charsets;

@Plugin(name="JsonLayout", category="Core", elementType="layout", printObject=true)
public final class JsonLayout
extends AbstractJacksonLayout {
    protected JsonLayout(boolean locationInfo, boolean properties, boolean complete, boolean compact, Charset charset) {
        super(new JacksonFactory.JSON().newWriter(locationInfo, properties, compact), charset, compact, complete);
    }

    @Override
    public byte[] getHeader() {
        if (!this.complete) {
            return null;
        }
        StringBuilder buf = new StringBuilder();
        buf.append('[');
        buf.append(this.eol);
        return buf.toString().getBytes(this.getCharset());
    }

    @Override
    public byte[] getFooter() {
        if (!this.complete) {
            return null;
        }
        return (this.eol + ']' + this.eol).getBytes(this.getCharset());
    }

    @Override
    public Map<String, String> getContentFormat() {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("version", "2.0");
        return result;
    }

    @Override
    public String getContentType() {
        return "application/json; charset=" + this.getCharset();
    }

    @PluginFactory
    public static AbstractJacksonLayout createLayout(@PluginAttribute(value="locationInfo", defaultBoolean=false) boolean locationInfo, @PluginAttribute(value="properties", defaultBoolean=false) boolean properties, @PluginAttribute(value="complete", defaultBoolean=false) boolean complete, @PluginAttribute(value="compact", defaultBoolean=false) boolean compact, @PluginAttribute(value="charset", defaultString="UTF-8") Charset charset) {
        return new JsonLayout(locationInfo, properties, complete, compact, charset);
    }

    public static AbstractJacksonLayout createDefaultLayout() {
        return new JsonLayout(false, false, false, false, Charsets.UTF_8);
    }
}

