/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.config.plugins.osgi;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.config.plugins.util.PluginManager;
import org.apache.logging.log4j.core.impl.Log4jContextFactory;
import org.apache.logging.log4j.core.util.BundleResourceLoader;
import org.apache.logging.log4j.simple.SimpleLoggerContextFactory;
import org.apache.logging.log4j.spi.LoggerContextFactory;
import org.apache.logging.log4j.status.StatusLogger;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;

public final class Activator
implements BundleActivator {
    private static final Logger LOGGER = StatusLogger.getLogger();

    public void start(BundleContext context) throws Exception {
        this.registerLoggerContextFactory();
        context.addBundleListener((BundleListener)new Listener());
        this.scanInstalledBundlesForPlugins(context);
    }

    private void registerLoggerContextFactory() {
        LoggerContextFactory current = LogManager.getFactory();
        if (!(current instanceof Log4jContextFactory)) {
            LOGGER.debug("Replacing LogManager LoggerContextFactory.");
            LogManager.setFactory((LoggerContextFactory)new Log4jContextFactory());
        }
    }

    private void scanInstalledBundlesForPlugins(BundleContext context) {
        Bundle[] bundles;
        for (Bundle bundle : bundles = context.getBundles()) {
            if (bundle.getState() != 32) continue;
            Activator.scanBundleForPlugins(bundle);
        }
    }

    private static void scanBundleForPlugins(Bundle bundle) {
        LOGGER.debug("Scanning bundle [{}] for plugins.", new Object[]{bundle.getSymbolicName()});
        PluginManager.loadPlugins(new BundleResourceLoader(bundle));
    }

    public void stop(BundleContext context) throws Exception {
        this.unregisterLoggerContextFactory();
    }

    private void unregisterLoggerContextFactory() {
        LogManager.setFactory((LoggerContextFactory)new SimpleLoggerContextFactory());
    }

    private static class Listener
    implements BundleListener {
        private Listener() {
        }

        public void bundleChanged(BundleEvent event) {
            switch (event.getType()) {
                case 2: {
                    Activator.scanBundleForPlugins(event.getBundle());
                    break;
                }
            }
        }
    }
}

