/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.icmp.jni;

import java.io.IOException;
import java.net.InetAddress;
import java.security.SecureRandom;
import java.util.List;
import java.util.concurrent.Callable;
import org.opennms.core.logging.Logging;
import org.opennms.netmgt.icmp.LogPrefixPreservingPingResponseCallback;
import org.opennms.netmgt.icmp.ParallelPingResponseCallback;
import org.opennms.netmgt.icmp.PingResponseCallback;
import org.opennms.netmgt.icmp.Pinger;
import org.opennms.netmgt.icmp.SinglePingResponseCallback;
import org.opennms.netmgt.icmp.jni.JniIcmpMessenger;
import org.opennms.netmgt.icmp.jni.JniPingRequest;
import org.opennms.netmgt.icmp.jni.JniPingResponse;
import org.opennms.protocols.rt.IDBasedRequestLocator;
import org.opennms.protocols.rt.Messenger;
import org.opennms.protocols.rt.Request;
import org.opennms.protocols.rt.RequestLocator;
import org.opennms.protocols.rt.RequestTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JniPinger
implements Pinger {
    private static final Logger LOG = LoggerFactory.getLogger(JniPinger.class);
    private final int m_pingerId = new SecureRandom().nextInt(Short.MAX_VALUE);
    private RequestTracker<JniPingRequest, JniPingResponse> s_pingTracker;
    private Throwable m_error = null;

    private synchronized void initialize() throws Exception {
        if (this.s_pingTracker != null) {
            return;
        }
        try {
            this.s_pingTracker = (RequestTracker)Logging.withPrefix((String)"icmp", (Callable)new Callable<RequestTracker<JniPingRequest, JniPingResponse>>(){

                @Override
                public RequestTracker<JniPingRequest, JniPingResponse> call() throws Exception {
                    return new RequestTracker("JNI-ICMP-" + JniPinger.this.m_pingerId, (Messenger)new JniIcmpMessenger(JniPinger.this.m_pingerId), (RequestLocator)new IDBasedRequestLocator());
                }
            });
            this.s_pingTracker.start();
        }
        catch (IOException ioe) {
            this.m_error = ioe;
            this.s_pingTracker = null;
            throw ioe;
        }
        catch (RuntimeException rte) {
            this.m_error = rte;
            this.s_pingTracker = null;
            throw rte;
        }
    }

    public void initialize4() throws Exception {
        this.initialize();
    }

    public void initialize6() throws Exception {
        throw new IllegalStateException("This pinger does not support IPv6.");
    }

    public boolean isV4Available() {
        try {
            this.initialize();
        }
        catch (Throwable t) {
            LOG.trace("Failed to initialize IPv4", t);
        }
        return this.s_pingTracker != null && this.m_error == null;
    }

    public boolean isV6Available() {
        return false;
    }

    public void ping(InetAddress host, long timeout, int retries, int packetsize, int sequenceId, PingResponseCallback cb) throws Exception {
        this.initialize();
        this.s_pingTracker.sendRequest((Request)new JniPingRequest(host, this.m_pingerId, sequenceId, timeout, retries, packetsize, (PingResponseCallback)new LogPrefixPreservingPingResponseCallback(cb)));
    }

    public void ping(InetAddress host, long timeout, int retries, int sequenceId, PingResponseCallback cb) throws Exception {
        this.initialize();
        this.s_pingTracker.sendRequest((Request)new JniPingRequest(host, this.m_pingerId, sequenceId, timeout, retries, 64, (PingResponseCallback)new LogPrefixPreservingPingResponseCallback(cb)));
    }

    public Number ping(InetAddress host, long timeout, int retries, int packetsize) throws Exception {
        SinglePingResponseCallback cb = new SinglePingResponseCallback(host);
        this.ping(host, timeout, retries, packetsize, 1, (PingResponseCallback)cb);
        cb.waitFor();
        cb.rethrowError();
        return cb.getResponseTime();
    }

    public Number ping(InetAddress host, long timeout, int retries) throws Exception {
        return this.ping(host, timeout, retries, 64);
    }

    public Number ping(InetAddress host) throws Exception {
        return this.ping(host, 800L, 2);
    }

    public List<Number> parallelPing(InetAddress host, int count, long timeout, long pingInterval) throws Exception {
        this.initialize();
        ParallelPingResponseCallback cb = new ParallelPingResponseCallback(count);
        long threadId = JniPingRequest.getNextTID();
        for (int seqNum = 0; seqNum < count; ++seqNum) {
            JniPingRequest request = new JniPingRequest(host, this.m_pingerId, seqNum, threadId, timeout == 0L ? 800L : timeout, 0, 64, (PingResponseCallback)cb);
            this.s_pingTracker.sendRequest((Request)request);
            Thread.sleep(pingInterval);
        }
        cb.waitFor();
        return cb.getResponseTimes();
    }
}

