/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.poller.monitors;

import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Map;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.core.utils.ParameterMap;
import org.opennms.core.utils.TimeoutTracker;
import org.opennms.netmgt.config.WmiPeerFactory;
import org.opennms.netmgt.config.wmi.WmiAgentConfig;
import org.opennms.netmgt.poller.Distributable;
import org.opennms.netmgt.poller.MonitoredService;
import org.opennms.netmgt.poller.NetworkInterface;
import org.opennms.netmgt.poller.NetworkInterfaceNotSupportedException;
import org.opennms.netmgt.poller.PollStatus;
import org.opennms.netmgt.poller.monitors.AbstractServiceMonitor;
import org.opennms.protocols.wmi.WmiException;
import org.opennms.protocols.wmi.WmiManager;
import org.opennms.protocols.wmi.WmiParams;
import org.opennms.protocols.wmi.WmiResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Distributable
public class WmiMonitor
extends AbstractServiceMonitor {
    private static final Logger LOG = LoggerFactory.getLogger(WmiMonitor.class);
    private static final String DEFAULT_WMI_CLASS = "Win32_ComputerSystem";
    private static final String DEFAULT_WMI_OBJECT = "Status";
    private static final String DEFAULT_WMI_COMP_VAL = "OK";
    private static final String DEFAULT_WMI_MATCH_TYPE = "all";
    private static final String DEFAULT_WMI_COMP_OP = "EQ";
    private static final String DEFAULT_WMI_NAMESPACE = "root/cimv2";
    private static final String DEFAULT_WMI_WQL = "NOTSET";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PollStatus poll(MonitoredService svc, Map<String, Object> parameters) {
        String reason = null;
        int serviceStatus = 2;
        WmiResult response = null;
        Double responseTime = null;
        NetworkInterface iface = svc.getNetInterface();
        InetAddress ipv4Addr = (InetAddress)iface.getAddress();
        if (iface.getType() != 1) {
            throw new NetworkInterfaceNotSupportedException("Unsupported interface type, only TYPE_INET currently supported");
        }
        WmiAgentConfig agentConfig = WmiPeerFactory.getInstance().getAgentConfig(ipv4Addr);
        String matchType = DEFAULT_WMI_MATCH_TYPE;
        String compVal = DEFAULT_WMI_COMP_VAL;
        String compOp = DEFAULT_WMI_COMP_OP;
        String wmiClass = DEFAULT_WMI_CLASS;
        String wmiObject = DEFAULT_WMI_OBJECT;
        String wmiWqlStr = DEFAULT_WMI_WQL;
        String wmiNamespace = DEFAULT_WMI_NAMESPACE;
        if (parameters != null) {
            if (parameters.get("timeout") != null) {
                int timeout = ParameterMap.getKeyedInteger(parameters, (String)"timeout", (int)agentConfig.getTimeout());
                agentConfig.setTimeout(timeout);
            }
            if (parameters.get("retry") != null) {
                int retries = ParameterMap.getKeyedInteger(parameters, (String)"retry", (int)agentConfig.getRetries());
                agentConfig.setRetries(retries);
            }
            if (parameters.get("username") != null) {
                String user = ParameterMap.getKeyedString(parameters, (String)"username", (String)agentConfig.getUsername());
                agentConfig.setUsername(user);
            }
            if (parameters.get("password") != null) {
                String pass = ParameterMap.getKeyedString(parameters, (String)"password", (String)agentConfig.getPassword());
                agentConfig.setUsername(pass);
            }
            if (parameters.get("domain") != null) {
                String domain = ParameterMap.getKeyedString(parameters, (String)"domain", (String)agentConfig.getDomain());
                agentConfig.setUsername(domain);
            }
            if (parameters.get("namespace") != null) {
                wmiNamespace = ParameterMap.getKeyedString(parameters, (String)"wmiNamespace", (String)ParameterMap.getKeyedString(parameters, (String)"namespace", (String)DEFAULT_WMI_NAMESPACE));
            }
            matchType = ParameterMap.getKeyedString(parameters, (String)"matchType", (String)DEFAULT_WMI_MATCH_TYPE);
            compVal = ParameterMap.getKeyedString(parameters, (String)"compareValue", (String)DEFAULT_WMI_COMP_VAL);
            compOp = ParameterMap.getKeyedString(parameters, (String)"compareOp", (String)DEFAULT_WMI_COMP_OP);
            wmiWqlStr = ParameterMap.getKeyedString(parameters, (String)"wql", (String)DEFAULT_WMI_WQL);
            wmiClass = ParameterMap.getKeyedString(parameters, (String)"wmiClass", (String)DEFAULT_WMI_CLASS);
            wmiObject = ParameterMap.getKeyedString(parameters, (String)"wmiObject", (String)DEFAULT_WMI_OBJECT);
        }
        TimeoutTracker tracker = new TimeoutTracker(parameters, agentConfig.getRetries(), agentConfig.getTimeout());
        String hostAddress = InetAddressUtils.str((InetAddress)ipv4Addr);
        LOG.debug("poll: address = {}, user = {}, {}", new Object[]{hostAddress, agentConfig.getUsername(), tracker});
        WmiManager mgr = null;
        tracker.reset();
        while (tracker.shouldRetry() && serviceStatus != 1) {
            try {
                tracker.startAttempt();
                LOG.debug("poll: creating WmiManager object.");
                mgr = new WmiManager(hostAddress, agentConfig.getUsername(), agentConfig.getPassword(), agentConfig.getDomain(), matchType);
                mgr.setTimeout(tracker.getSoTimeout());
                mgr.setNamespace(wmiNamespace);
                mgr.init();
                LOG.debug("Completed initializing WmiManager object.");
                serviceStatus = 3;
                WmiParams clientParams = null;
                if (DEFAULT_WMI_WQL.equals(wmiWqlStr)) {
                    clientParams = new WmiParams("InstanceOf", compVal, compOp, wmiClass, wmiObject);
                    LOG.debug("Attempting to perform operation: \\\\{}\\{}", (Object)wmiClass, (Object)wmiObject);
                } else {
                    clientParams = new WmiParams("Wql", compVal, compOp, wmiWqlStr, wmiObject);
                    LOG.debug("Attempting to perform operation: {}", (Object)wmiWqlStr);
                }
                response = mgr.performOp(clientParams);
                LOG.debug("Received result: {}", (Object)response);
                responseTime = tracker.elapsedTimeInMillis();
                if (response != null) {
                    ArrayList<Object> wmiObjects = response.getResponse();
                    StringBuffer reasonBuffer = new StringBuffer();
                    reasonBuffer.append("Constraint '").append(matchType).append(" ").append(clientParams.getCompareOperation()).append(" ").append(clientParams.getCompareValue()).append("' failed for value of ");
                    if (DEFAULT_WMI_WQL.equals(wmiWqlStr)) {
                        reasonBuffer.append(wmiClass).append("\\").append(wmiObject);
                    } else {
                        reasonBuffer.append("\"").append(wmiWqlStr).append("\"");
                    }
                    if (response.getResultCode() == 0) {
                        serviceStatus = 1;
                        reasonBuffer.append(": ").append(wmiObjects.get(0));
                    } else if (response.getResultCode() == 1) {
                        serviceStatus = 2;
                        responseTime = null;
                    }
                    reason = reasonBuffer.toString();
                }
            }
            catch (WmiException e) {
                LOG.debug("WMI Poller received exception from client.", (Throwable)e);
                reason = "WmiException: " + e.getMessage();
            }
            finally {
                if (mgr != null) {
                    try {
                        mgr.close();
                    }
                    catch (WmiException e) {
                        LOG.warn("An error occurred closing the WMI Manager.", (Throwable)e);
                    }
                }
            }
            tracker.nextAttempt();
        }
        return PollStatus.get((int)serviceStatus, reason, responseTime);
    }
}

