/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.core.utils;

import java.util.Date;

public class FuzzyDateFormatter {
    private static final double MILLISECONDS_PER_SECOND = 1000.0;
    private static final double MILLISECONDS_PER_DAY = 8.64E7;
    private static final double MILLISECONDS_PER_HOUR = 3600000.0;
    private static final double MILLISECONDS_PER_MINUTE = 60000.0;

    protected static String formatNumber(Double number, String singular, String plural) {
        String returnVal = Long.toString(Math.round(number));
        returnVal = returnVal.equals("1") ? number.intValue() + " " + singular : returnVal + " " + plural;
        return returnVal;
    }

    public static String calculateDifference(Date start, Date end) {
        Long difference = Math.abs(end.getTime() - start.getTime());
        double days = difference.doubleValue() / 8.64E7;
        if (days < 1.0) {
            double hours = difference.doubleValue() / 3600000.0;
            if (hours < 1.0) {
                double minutes = difference.doubleValue() / 60000.0;
                if (minutes < 1.0) {
                    double seconds = (double)difference.floatValue() / 1000.0;
                    return FuzzyDateFormatter.formatNumber(seconds, "second", "seconds");
                }
                return FuzzyDateFormatter.formatNumber(minutes, "minute", "minutes");
            }
            return FuzzyDateFormatter.formatNumber(hours, "hour", "hours");
        }
        if (days >= 365.0) {
            return FuzzyDateFormatter.formatNumber(days / 365.0, "year", "years");
        }
        if (days >= 30.0) {
            return FuzzyDateFormatter.formatNumber(days / 30.0, "month", "months");
        }
        if (days >= 7.0) {
            return FuzzyDateFormatter.formatNumber(days / 7.0, "week", "weeks");
        }
        if (days >= 1.0) {
            return FuzzyDateFormatter.formatNumber(days, "day", "days");
        }
        return null;
    }
}

