/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.snmp.joesnmp;

import java.net.InetAddress;
import org.opennms.netmgt.snmp.SnmpObjId;
import org.opennms.netmgt.snmp.SnmpV1TrapBuilder;
import org.opennms.netmgt.snmp.SnmpValue;
import org.opennms.netmgt.snmp.joesnmp.JoeSnmpStrategy;
import org.opennms.netmgt.snmp.joesnmp.JoeSnmpValue;
import org.opennms.protocols.snmp.SnmpIPAddress;
import org.opennms.protocols.snmp.SnmpObjectId;
import org.opennms.protocols.snmp.SnmpPduTrap;
import org.opennms.protocols.snmp.SnmpSyntax;
import org.opennms.protocols.snmp.SnmpVarBind;

public class JoeSnmpV1TrapBuilder
implements SnmpV1TrapBuilder {
    SnmpPduTrap trap = new SnmpPduTrap();

    public void setEnterprise(SnmpObjId enterpriseId) {
        this.trap.setEnterprise(new SnmpObjectId(enterpriseId.getIds()));
    }

    public void setAgentAddress(InetAddress agentAddress) {
        this.trap.setAgentAddress(new SnmpIPAddress(agentAddress));
    }

    public void setGeneric(int generic) {
        this.trap.setGeneric(generic);
    }

    public void setSpecific(int specific) {
        this.trap.setSpecific(specific);
    }

    public void setTimeStamp(long timeStamp) {
        this.trap.setTimeStamp(timeStamp);
    }

    public void send(String destAddr, int destPort, String community) throws Exception {
        JoeSnmpStrategy.send(destAddr, destPort, community, this.trap);
    }

    public void sendTest(String destAddr, int destPort, String community) throws Exception {
        JoeSnmpStrategy.sendTest(destAddr, destPort, community, this.trap);
    }

    public void addVarBind(SnmpObjId name, SnmpValue value) {
        SnmpSyntax val = ((JoeSnmpValue)value).getSnmpSyntax();
        this.trap.addVarBind(new SnmpVarBind(new SnmpObjectId(name.getIds()), val));
    }
}

