/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.dao.hibernate;

import java.util.Date;
import java.util.List;
import org.opennms.netmgt.dao.api.CdpLinkDao;
import org.opennms.netmgt.dao.hibernate.AbstractDaoHibernate;
import org.opennms.netmgt.model.CdpLink;
import org.opennms.netmgt.model.OnmsNode;
import org.springframework.util.Assert;

public class CdpLinkDaoHibernate
extends AbstractDaoHibernate<CdpLink, Integer>
implements CdpLinkDao {
    public CdpLinkDaoHibernate() {
        super(CdpLink.class);
    }

    public CdpLink get(OnmsNode node, Integer cdpCacheifIndex) {
        return (CdpLink)this.findUnique("from CdpLink as cdpLink where cdpLink.node = ? and cdpLink.cdpCacheIfIndex = ?", node, cdpCacheifIndex);
    }

    public CdpLink get(Integer nodeId, Integer cdpCacheifIndex) {
        Assert.notNull((Object)nodeId, (String)"nodeId cannot be null");
        Assert.notNull((Object)cdpCacheifIndex, (String)"cdpCacheifIndex cannot be null");
        return (CdpLink)this.findUnique("from CdpLink as cdpLink where cdpLink.node.id = ? and cdpLink.cdpCacheIfIndex = ?", nodeId, cdpCacheifIndex);
    }

    public List<CdpLink> findByNodeId(Integer nodeId) {
        Assert.notNull((Object)nodeId, (String)"nodeId cannot be null");
        return this.find("from CdpLink cdpLink where cdpLink.node.id = ?", nodeId);
    }

    public void deleteByNodeIdOlderThen(Integer nodeId, Date now) {
        for (CdpLink link : this.find("from CdpLink cdpLink where cdpLink.node.id = ? and cdpLink.cdpLinkLastPollTime < ?", nodeId, now)) {
            this.delete(link);
        }
    }
}

