/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.dao.hibernate;

import java.util.ArrayList;
import java.util.List;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.hibernate.type.IntegerType;
import org.hibernate.type.StringType;
import org.hibernate.type.Type;
import org.opennms.netmgt.dao.api.CategoryDao;
import org.opennms.netmgt.dao.hibernate.AbstractCachingDaoHibernate;
import org.opennms.netmgt.model.OnmsCategory;
import org.opennms.netmgt.model.OnmsCriteria;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class CategoryDaoHibernate
extends AbstractCachingDaoHibernate<OnmsCategory, Integer, String>
implements CategoryDao {
    public CategoryDaoHibernate() {
        super(OnmsCategory.class, false);
    }

    public OnmsCategory findByName(String name) {
        return this.findByName(name, true);
    }

    public OnmsCategory findByName(String name, boolean useCached) {
        if (useCached) {
            return (OnmsCategory)this.findByCacheKey("from OnmsCategory as category where category.name = ?", name);
        }
        return (OnmsCategory)this.findUnique("from OnmsCategory as category where category.name = ?", name);
    }

    @Override
    protected String getKey(OnmsCategory category) {
        return category.getName();
    }

    public List<String> getAllCategoryNames() {
        return this.findObjects(String.class, "select category.name from OnmsCategory as category", new Object[0]);
    }

    /*
     * WARNING - void declaration
     */
    public List<Criterion> getCriterionForCategorySetsUnion(String[] ... categories) {
        void var5_7;
        Assert.notNull((Object)categories, (String)"categories argument must not be null");
        Assert.isTrue((categories.length >= 1 ? 1 : 0) != 0, (String)"categories must have at least one set of categories");
        ArrayList categoryIdsList = new ArrayList(categories.length);
        String[][] arr$ = categories;
        int len$ = arr$.length;
        boolean bl = false;
        while (var5_7 < len$) {
            String[] categoryStrings = arr$[var5_7];
            ArrayList<Integer> categoryIds = new ArrayList<Integer>(categoryStrings.length);
            for (String categoryString : categoryStrings) {
                OnmsCategory category = this.findByName(categoryString);
                if (category == null) {
                    throw new IllegalArgumentException("Could not find category for name '" + categoryString + "'");
                }
                categoryIds.add(category.getId());
            }
            categoryIdsList.add(categoryIds);
            ++var5_7;
        }
        ArrayList<Criterion> criteria = new ArrayList<Criterion>(categoryIdsList.size());
        for (List list : categoryIdsList) {
            Type[] types = new Type[list.size()];
            Object[] questionMarks = new String[list.size()];
            IntegerType theOneAndOnlyType = new IntegerType();
            for (int i = 0; i < list.size(); ++i) {
                types[i] = theOneAndOnlyType;
                questionMarks[i] = "?";
            }
            String sql = "{alias}.nodeId in (select distinct cn.nodeId from category_node cn where cn.categoryId in (" + StringUtils.arrayToCommaDelimitedString((Object[])questionMarks) + "))";
            criteria.add(Restrictions.sqlRestriction((String)sql, (Object[])list.toArray(new Integer[list.size()]), (Type[])types));
        }
        return criteria;
    }

    public List<OnmsCategory> getCategoriesWithAuthorizedGroup(String groupName) {
        OnmsCriteria crit = new OnmsCriteria(OnmsCategory.class);
        crit.add(Restrictions.sqlRestriction((String)"{alias}.categoryId in (select cg.categoryId from category_group cg where cg.groupId = ?)", (Object)groupName, (Type)StringType.INSTANCE));
        return this.findMatching(crit);
    }
}

