/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.core.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import org.opennms.core.utils.TimeInterval;

public abstract class AbstractTimeIntervalSequence<T extends TimeInterval> {
    private T m_interval;
    private AbstractTimeIntervalSequence<T> m_tail;

    public AbstractTimeIntervalSequence() {
        this(null, null);
    }

    public AbstractTimeIntervalSequence(T interval) {
        this(interval, null);
    }

    private AbstractTimeIntervalSequence(T interval, AbstractTimeIntervalSequence<T> tail) {
        this.m_interval = interval;
        this.m_tail = tail;
    }

    public Iterator<T> iterator() {
        return new TimeIntervalSeqIter(this);
    }

    Date min(Date a, Date b) {
        return a.before(b) ? a : b;
    }

    Date max(Date a, Date b) {
        return b.before(a) ? a : b;
    }

    public void addInterval(T interval) {
        if (this.m_interval == null) {
            this.m_interval = interval;
        } else if (((TimeInterval)this.m_interval).preceeds((TimeInterval)interval)) {
            this.addPreceedingInterval(interval);
        } else if (((TimeInterval)this.m_interval).follows((TimeInterval)interval)) {
            this.addSucceedingInterval(interval);
        } else if (((TimeInterval)this.m_interval).overlaps((TimeInterval)interval)) {
            this.addOverlappingInterval(interval);
        }
    }

    private void addOverlappingInterval(T newInterval) {
        Collection<T> newIntervals = this.combineIntervals(this.m_interval, newInterval);
        this.removeCurrent();
        this.addAll(newIntervals);
    }

    protected Collection<T> combineIntervals(T currentInterval, T newInterval) {
        ArrayList<T> newIntervals = new ArrayList<T>(3);
        Date first = this.min(((TimeInterval)currentInterval).getStart(), ((TimeInterval)newInterval).getStart());
        Date second = this.max(((TimeInterval)currentInterval).getStart(), ((TimeInterval)newInterval).getStart());
        Date third = this.min(((TimeInterval)currentInterval).getEnd(), ((TimeInterval)newInterval).getEnd());
        Date fourth = this.max(((TimeInterval)currentInterval).getEnd(), ((TimeInterval)newInterval).getEnd());
        if (first.equals(second)) {
            newIntervals.add(this.createInterval(first, third));
        } else {
            newIntervals.add(this.createInterval(first, second));
            newIntervals.add(this.createInterval(second, third));
        }
        if (!third.equals(fourth)) {
            newIntervals.add(this.createInterval(third, fourth));
        }
        return newIntervals;
    }

    private void addSucceedingInterval(T interval) {
        AbstractTimeIntervalSequence<T> oldTail = this.m_tail;
        this.m_tail = this.createTail(this.m_interval);
        this.m_tail.m_tail = oldTail;
        this.m_interval = interval;
    }

    private void addPreceedingInterval(T interval) {
        this.addToTail(interval);
    }

    private void addToTail(T interval) {
        if (this.m_tail == null) {
            this.m_tail = this.createTail(interval);
        } else {
            this.m_tail.addInterval(interval);
        }
    }

    protected abstract T createInterval(Date var1, Date var2);

    protected abstract AbstractTimeIntervalSequence<T> createTail(T var1);

    private void removeCurrent() {
        if (this.m_tail == null) {
            this.m_interval = null;
        } else {
            this.m_interval = this.m_tail.m_interval;
            this.m_tail = this.m_tail.m_tail;
        }
    }

    public void removeInterval(T removedInterval) {
        if (this.m_interval == null) {
            return;
        }
        if (((TimeInterval)this.m_interval).preceeds((TimeInterval)removedInterval)) {
            this.removeFromTail(removedInterval);
        } else {
            if (((TimeInterval)this.m_interval).follows((TimeInterval)removedInterval)) {
                return;
            }
            if (((TimeInterval)this.m_interval).overlaps((TimeInterval)removedInterval)) {
                T origInterval = this.m_interval;
                this.removeFromTail(removedInterval);
                this.removeCurrent();
                Collection<T> newIntervals = this.separateIntervals(origInterval, removedInterval);
                this.addAll(newIntervals);
            }
        }
    }

    protected Collection<T> separateIntervals(T origInterval, T removedInterval) {
        ArrayList<T> newIntervals = new ArrayList<T>(2);
        if (((TimeInterval)removedInterval).getEnd().before(((TimeInterval)origInterval).getEnd())) {
            newIntervals.add(this.createInterval(((TimeInterval)removedInterval).getEnd(), ((TimeInterval)origInterval).getEnd()));
        }
        if (((TimeInterval)origInterval).getStart().before(((TimeInterval)removedInterval).getStart())) {
            newIntervals.add(this.createInterval(((TimeInterval)origInterval).getStart(), ((TimeInterval)removedInterval).getStart()));
        }
        return newIntervals;
    }

    private void removeFromTail(T interval) {
        if (this.m_tail == null) {
            return;
        }
        this.m_tail.removeInterval(interval);
        if (this.m_tail.m_interval == null) {
            this.m_tail = null;
        }
    }

    public void bound(Date start, Date end) {
        this.removeInterval(this.createInterval(new Date(0L), start));
        this.removeInterval(this.createInterval(end, new Date(Long.MAX_VALUE)));
    }

    public void bound(T interval) {
        this.bound(((TimeInterval)interval).getStart(), ((TimeInterval)interval).getEnd());
    }

    public Date getStart() {
        if (this.m_interval == null) {
            return null;
        }
        return ((TimeInterval)this.m_interval).getStart();
    }

    public Date getEnd() {
        if (this.m_interval == null) {
            return null;
        }
        if (this.m_tail == null) {
            return ((TimeInterval)this.m_interval).getEnd();
        }
        return this.m_tail.getEnd();
    }

    public TimeInterval getBounds() {
        Date start = this.getStart();
        Date end = this.getEnd();
        return start == null || end == null ? null : new TimeInterval(start, end);
    }

    public void addAll(AbstractTimeIntervalSequence<T> intervals) {
        Iterator<T> it = intervals.iterator();
        while (it.hasNext()) {
            TimeInterval interval = (TimeInterval)it.next();
            this.addInterval(interval);
        }
    }

    public void addAll(Collection<T> intervals) {
        for (TimeInterval interval : intervals) {
            this.addInterval(interval);
        }
    }

    public void removeAll(AbstractTimeIntervalSequence<T> intervals) {
        Iterator<T> it = intervals.iterator();
        while (it.hasNext()) {
            TimeInterval interval = (TimeInterval)it.next();
            this.removeInterval(interval);
        }
    }

    public String toString() {
        StringBuffer buf = new StringBuffer("[");
        boolean first = true;
        Iterator<T> it = this.iterator();
        while (it.hasNext()) {
            TimeInterval interval = (TimeInterval)it.next();
            if (first) {
                first = false;
            } else {
                buf.append(",");
            }
            buf.append(interval);
        }
        buf.append(']');
        return buf.toString();
    }

    private static class TimeIntervalSeqIter<T extends TimeInterval>
    implements Iterator<T> {
        private AbstractTimeIntervalSequence<T> m_current;

        public TimeIntervalSeqIter(AbstractTimeIntervalSequence<T> seq) {
            this.m_current = seq;
        }

        @Override
        public boolean hasNext() {
            return this.m_current != null && ((AbstractTimeIntervalSequence)this.m_current).m_interval != null;
        }

        @Override
        public T next() {
            TimeInterval interval = ((AbstractTimeIntervalSequence)this.m_current).m_interval;
            this.m_current = ((AbstractTimeIntervalSequence)this.m_current).m_tail;
            return (T)interval;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("not implemented yet");
        }
    }
}

