/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.icmp.jni6;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.concurrent.TimeUnit;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.icmp.jni6.Jni6IcmpMessenger;
import org.opennms.netmgt.icmp.jni6.Jni6PingResponse;
import org.opennms.protocols.icmp.ICMPEchoPacket;
import org.opennms.protocols.icmp.IcmpSocket;
import org.opennms.protocols.icmp6.ICMPv6Socket;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Ping {
    private static final Logger LOG = LoggerFactory.getLogger(Ping.class);

    public static void main(String[] argv) {
        if (argv.length != 1) {
            System.err.println("incorrect number of command-line arguments.");
            System.err.println("usage: java -cp ... " + IcmpSocket.class.getName() + " <host>");
            System.exit(1);
        }
        String host = argv[0];
        ICMPv6Socket m_socket = null;
        try {
            m_socket = new ICMPv6Socket();
        }
        catch (UnsatisfiedLinkError e) {
            System.err.println("UnsatisfiedLinkError while creating an IcmpSocket.  Most likely failed to load libjicmp.so.  Try setting the property 'opennms.library.jicmp' to point at the full path name of the libjicmp.so shared library (e.g. 'java -Dopennms.library.jicmp=/some/path/libjicmp.so ...')");
            e.printStackTrace();
            System.exit(1);
        }
        catch (NoClassDefFoundError e) {
            System.err.println("NoClassDefFoundError while creating an IcmpSocket.  Most likely failed to load libjicmp.so.");
            e.printStackTrace();
            System.exit(1);
        }
        catch (IOException e) {
            System.err.println("IOException while creating an IcmpSocket.");
            e.printStackTrace();
            System.exit(1);
        }
        InetAddress addr = null;
        try {
            addr = InetAddress.getByName(host);
        }
        catch (UnknownHostException e) {
            System.err.println("UnknownHostException when looking up " + host + ".");
            e.printStackTrace();
            System.exit(1);
        }
        System.out.println("PING " + host + " (" + InetAddressUtils.str((InetAddress)addr) + "): 56 data bytes");
        short m_icmpId = 2;
        Stuff s = new Stuff(m_socket, m_icmpId);
        Thread t = new Thread((Runnable)s, Ping.class.getSimpleName());
        t.start();
        long m_fiberId = 0L;
        while (true) {
            ICMPEchoPacket pingPkt = new ICMPEchoPacket(m_fiberId);
            pingPkt.setIdentity(m_icmpId);
            pingPkt.computeChecksum();
            byte[] buf = pingPkt.toBytes();
            DatagramPacket sendPkt = new DatagramPacket(buf, buf.length, addr, 0);
            buf = null;
            pingPkt = null;
            try {
                m_socket.send(sendPkt);
            }
            catch (IOException e) {
                System.err.println("IOException received when sending packet.");
                e.printStackTrace();
                System.exit(1);
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            ++m_fiberId;
        }
    }

    public static class Stuff
    implements Runnable {
        private ICMPv6Socket m_socket;
        private short m_icmpId;

        public Stuff(ICMPv6Socket socket, short icmpId) {
            this.m_socket = socket;
            this.m_icmpId = icmpId;
        }

        @Override
        public void run() {
            try {
                while (true) {
                    Jni6PingResponse reply;
                    DatagramPacket pkt = this.m_socket.receive();
                    try {
                        reply = Jni6IcmpMessenger.createPingResponse(pkt);
                    }
                    catch (Throwable t) {
                        continue;
                    }
                    if (!reply.isEchoReply() || reply.getThreadId() != (long)this.m_icmpId) continue;
                    double rtt = reply.elapsedTime(TimeUnit.MILLISECONDS);
                    System.out.println(ICMPEchoPacket.getNetworkSize() + " bytes from " + InetAddressUtils.str((InetAddress)pkt.getAddress()) + ": icmp_seq=" + reply.getIdentifier() + ". time=" + rtt + " ms");
                }
            }
            catch (Throwable t) {
                LOG.error("An exception occured processing the datagram, thread exiting.", t);
                System.exit(1);
                return;
            }
        }
    }
}

