/*
 * Decompiled with CFR 0.152.
 */
package rpc.pdu;

import ndr.NetworkDataRepresentation;
import rpc.ConnectionOrientedPdu;
import rpc.core.PresentationContext;

public class AlterContextPdu
extends ConnectionOrientedPdu {
    public static final int ALTER_CONTEXT_TYPE = 14;
    private PresentationContext[] contextList;
    private int maxTransmitFragment = -1;
    private int maxReceiveFragment = -1;
    private int associationGroupId = 0;

    public int getType() {
        return 14;
    }

    public int getMaxTransmitFragment() {
        return this.maxTransmitFragment;
    }

    public void setMaxTransmitFragment(int maxTransmitFragment) {
        this.maxTransmitFragment = maxTransmitFragment;
    }

    public int getMaxReceiveFragment() {
        return this.maxReceiveFragment;
    }

    public void setMaxReceiveFragment(int maxReceiveFragment) {
        this.maxReceiveFragment = maxReceiveFragment;
    }

    public int getAssociationGroupId() {
        return this.associationGroupId;
    }

    public void setAssociationGroupId(int associationGroupId) {
        this.associationGroupId = associationGroupId;
    }

    public PresentationContext[] getContextList() {
        return this.contextList;
    }

    public void setContextList(PresentationContext[] contextList) {
        this.contextList = contextList;
    }

    protected void readBody(NetworkDataRepresentation ndr) {
        this.setMaxTransmitFragment(ndr.readUnsignedShort());
        this.setMaxReceiveFragment(ndr.readUnsignedShort());
        this.setAssociationGroupId(ndr.readUnsignedLong());
        int count = ndr.readUnsignedSmall();
        PresentationContext[] contextList = new PresentationContext[count];
        int i = 0;
        while (i < count) {
            contextList[i] = new PresentationContext();
            contextList[i].read(ndr);
            ++i;
        }
        this.setContextList(contextList);
    }

    protected void writeBody(NetworkDataRepresentation ndr) {
        int maxTransmitFragment = this.getMaxTransmitFragment();
        int maxReceiveFragment = this.getMaxReceiveFragment();
        ndr.writeUnsignedShort(maxTransmitFragment == -1 ? ndr.getBuffer().getCapacity() : maxTransmitFragment);
        ndr.writeUnsignedShort(maxReceiveFragment == -1 ? ndr.getBuffer().getCapacity() : maxReceiveFragment);
        ndr.writeUnsignedLong(this.getAssociationGroupId());
        PresentationContext[] contextList = this.getContextList();
        int count = contextList.length;
        ndr.writeUnsignedSmall((short)count);
        int i = 0;
        while (i < count) {
            contextList[i].write(ndr);
            ++i;
        }
    }
}

