/*
 * Decompiled with CFR 0.152.
 */
package com.iwombat.util;

public final class HexStringUtil {
    private static final short BYTE_SHIFT = 8;
    private static final short LOW_BYTE_MASK = 255;
    private static final short HIGH_NIBBLE_MASK = 240;
    private static final int RADIX = 16;
    private static final String HEX_TOKEN = "0x";

    private HexStringUtil() {
    }

    public static byte[] bytesFromHexString(String hexString) {
        int length;
        if (hexString.startsWith(HEX_TOKEN)) {
            hexString = hexString.substring(HEX_TOKEN.length());
        }
        if ((length = hexString.length() / 2) == 0) {
            throw new IllegalArgumentException("zero length string");
        }
        if (hexString.length() % 2 != 0) {
            throw new IllegalArgumentException("odd length string");
        }
        byte[] tempArray = new byte[length];
        int i = 0;
        while (i < length) {
            try {
                String temp = hexString.substring(i * 2, i * 2 + 2);
                char[] digs = temp.toCharArray();
                int theValue = Character.digit(digs[0], 16) * 16;
                tempArray[i] = (byte)(theValue += Character.digit(digs[1], 16));
            }
            catch (Exception e) {
                throw new IllegalArgumentException("improperly formed hex string");
            }
            ++i;
        }
        return tempArray;
    }

    public static String stringFromBytes(byte[] byteArray) {
        StringBuffer str = new StringBuffer("");
        int i = 0;
        while (i < byteArray.length) {
            if ((byteArray[i] & 0xF0) > 0) {
                str.append(Integer.toHexString(byteArray[i] & 0xFF));
            } else {
                str.append("0" + Integer.toHexString(byteArray[i] & 0xFF));
            }
            ++i;
        }
        return str.toString();
    }

    public static String stringFromBytesWithToken(byte[] byteArray) {
        return new String(HEX_TOKEN + HexStringUtil.stringFromBytes(byteArray));
    }
}

