/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.binding.mapping.impl;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.binding.mapping.Mapper;
import org.springframework.binding.mapping.Mapping;
import org.springframework.binding.mapping.MappingResults;
import org.springframework.binding.mapping.impl.DefaultMapping;
import org.springframework.binding.mapping.impl.DefaultMappingContext;
import org.springframework.core.style.ToStringCreator;

public class DefaultMapper
implements Mapper {
    private static final Log logger = LogFactory.getLog(DefaultMapper.class);
    private List mappings = new ArrayList();

    public DefaultMapper addMapping(DefaultMapping mapping) {
        this.mappings.add(mapping);
        return this;
    }

    public Mapping[] getMappings() {
        return this.mappings.toArray(new Mapping[this.mappings.size()]);
    }

    public MappingResults map(Object source, Object target) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Beginning mapping between source [" + source.getClass().getName() + "] and target [" + target.getClass().getName() + "]"));
        }
        DefaultMappingContext context = new DefaultMappingContext(source, target);
        for (DefaultMapping mapping : this.mappings) {
            mapping.map(context);
        }
        MappingResults results = context.getMappingResults();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Completing mapping between source [" + source.getClass().getName() + "] and target [" + target.getClass().getName() + "]; total mappings = " + results.getAllResults().size() + "; total errors = " + results.getErrorResults().size()));
        }
        return results;
    }

    public String toString() {
        return new ToStringCreator((Object)this).append("mappings", (Object)this.mappings).toString();
    }
}

