/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.binding.convert;

import org.springframework.binding.convert.ConversionException;
import org.springframework.core.style.StylerUtils;

public class ConversionExecutionException
extends ConversionException {
    private transient Object value;
    private Class sourceClass;
    private Class targetClass;

    public ConversionExecutionException(Object value, Class sourceClass, Class targetClass, Throwable cause) {
        super(ConversionExecutionException.defaultMessage(value, sourceClass, targetClass, cause), cause);
        this.value = value;
        this.sourceClass = sourceClass;
        this.targetClass = targetClass;
    }

    public ConversionExecutionException(Object value, Class sourceClass, Class targetClass, String message) {
        super(message);
        this.value = value;
        this.sourceClass = sourceClass;
        this.targetClass = targetClass;
    }

    public Object getValue() {
        return this.value;
    }

    public Class getSourceClass() {
        return this.sourceClass;
    }

    public Class getTargetClass() {
        return this.targetClass;
    }

    private static String defaultMessage(Object value, Class sourceClass, Class targetClass, Throwable cause) {
        return "Unable to convert value " + StylerUtils.style((Object)value) + " from type '" + sourceClass.getName() + "' to type '" + targetClass.getName() + "'; reason = '" + cause.getMessage() + "'";
    }
}

