/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.core.soa.support;

import java.util.Map;
import org.opennms.core.soa.Registration;
import org.opennms.core.soa.ServiceRegistry;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class ServiceFactoryBean
implements FactoryBean<Registration>,
BeanFactoryAware,
InitializingBean,
DisposableBean {
    private BeanFactory m_beanFactory;
    private ServiceRegistry m_serviceRegistry;
    private String m_targetBeanName;
    private Object m_target;
    private Class<?>[] m_serviceInterfaces;
    private Map<String, String> m_serviceProperties;
    private Registration m_registration;

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.m_beanFactory = beanFactory;
    }

    public void setTargetBeanName(String targetBeanName) {
        this.m_targetBeanName = targetBeanName;
    }

    public void setTarget(Object target) {
        this.m_target = target;
    }

    public void setInterfaces(Class<?>[] serviceInterfaces) {
        this.m_serviceInterfaces = serviceInterfaces;
    }

    public void setServiceProperties(Map<String, String> serviceProperties) {
        this.m_serviceProperties = serviceProperties;
    }

    public void setServiceRegistry(ServiceRegistry serviceRegistry) {
        this.m_serviceRegistry = serviceRegistry;
    }

    public void afterPropertiesSet() throws Exception {
        boolean hasText = StringUtils.hasText((String)this.m_targetBeanName);
        Assert.isTrue((hasText || this.m_target != null ? 1 : 0) != 0, (String)"targetBeanName or target must be set");
        Assert.notEmpty((Object[])this.m_serviceInterfaces, (String)"interfaces must be set");
        if (this.m_target == null) {
            Assert.notNull((Object)this.m_beanFactory, (String)"beanFactory must not be null");
        }
        Object provider = this.m_target != null ? this.m_target : this.m_beanFactory.getBean(this.m_targetBeanName);
        this.m_registration = this.m_serviceRegistry.register(provider, this.m_serviceProperties, this.m_serviceInterfaces);
    }

    public void destroy() throws Exception {
        if (this.m_registration != null) {
            this.m_registration.unregister();
        }
    }

    public Registration getObject() throws Exception {
        return this.m_registration;
    }

    public Class<? extends Registration> getObjectType() {
        return this.m_registration == null ? Registration.class : this.m_registration.getClass();
    }

    public boolean isSingleton() {
        return true;
    }
}

