/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.core.soa.support;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.opennms.core.soa.support.MultivaluedMap;

public class MultivaluedMapImpl<K, V>
extends LinkedHashMap<K, Set<V>>
implements MultivaluedMap<K, V> {
    private static final long serialVersionUID = -4898439337217431661L;

    @Override
    public void add(K key, V value) {
        if (!this.containsKey(key)) {
            LinkedHashSet<V> valueList = new LinkedHashSet<V>();
            valueList.add(value);
            this.put(key, valueList);
        } else {
            ((Set)this.get(key)).add(value);
        }
    }

    @Override
    public boolean remove(K key, V value) {
        if (!this.containsKey(key)) {
            return false;
        }
        Set valueList = (Set)this.get(key);
        boolean found = valueList.remove(value);
        if (valueList.isEmpty()) {
            this.remove(key);
        }
        return found;
    }

    @Override
    public Set<V> getCopy(K key) {
        Set values = (Set)this.get(key);
        return values == null ? null : new LinkedHashSet(values);
    }

    public static <Key, Value> MultivaluedMap<Key, Value> synchronizedMultivaluedMap(MultivaluedMap<Key, Value> m) {
        return new SynchronizedMultivaluedMap<Key, Value>(m);
    }

    public static <Key, Value> MultivaluedMap<Key, Value> synchronizedMultivaluedMap() {
        return MultivaluedMapImpl.synchronizedMultivaluedMap(new MultivaluedMapImpl());
    }

    public static class SynchronizedMultivaluedMap<Key, Value>
    implements MultivaluedMap<Key, Value> {
        MultivaluedMap<Key, Value> m_data;
        Object m_lock;

        public SynchronizedMultivaluedMap(MultivaluedMap<Key, Value> m) {
            this.m_data = m;
            this.m_lock = this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void add(Key key, Value value) {
            Object object = this.m_lock;
            synchronized (object) {
                this.m_data.add(key, value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean remove(Key key, Value value) {
            Object object = this.m_lock;
            synchronized (object) {
                return this.m_data.remove(key, value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Set<Value> getCopy(Key key) {
            Object object = this.m_lock;
            synchronized (object) {
                return this.m_data.getCopy(key);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void clear() {
            Object object = this.m_lock;
            synchronized (object) {
                this.m_data.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean containsKey(Object key) {
            Object object = this.m_lock;
            synchronized (object) {
                return this.m_data.containsKey(key);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean containsValue(Object value) {
            Object object = this.m_lock;
            synchronized (object) {
                return this.m_data.containsValue(value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Set<Map.Entry<Key, Set<Value>>> entrySet() {
            Object object = this.m_lock;
            synchronized (object) {
                return this.m_data.entrySet();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Set<Value> get(Object key) {
            Object object = this.m_lock;
            synchronized (object) {
                return (Set)this.m_data.get(key);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isEmpty() {
            Object object = this.m_lock;
            synchronized (object) {
                return this.m_data.isEmpty();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Set<Key> keySet() {
            Object object = this.m_lock;
            synchronized (object) {
                return this.m_data.keySet();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Set<Value> put(Key key, Set<Value> value) {
            Object object = this.m_lock;
            synchronized (object) {
                return this.m_data.put(key, value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void putAll(Map<? extends Key, ? extends Set<Value>> t) {
            Object object = this.m_lock;
            synchronized (object) {
                this.m_data.putAll(t);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Set<Value> remove(Object key) {
            Object object = this.m_lock;
            synchronized (object) {
                return (Set)this.m_data.remove(key);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int size() {
            Object object = this.m_lock;
            synchronized (object) {
                return this.m_data.size();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Collection<Set<Value>> values() {
            Object object = this.m_lock;
            synchronized (object) {
                return this.m_data.values();
            }
        }
    }
}

