/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.core.soa.filter;

import java.util.regex.Pattern;
import org.opennms.core.soa.filter.AttributeComparisonFilter;

public class PatternMatchingFilter
extends AttributeComparisonFilter {
    private Pattern m_pattern;

    private PatternMatchingFilter(String attribute, Pattern pattern) {
        super(attribute);
        this.m_pattern = pattern;
    }

    public PatternMatchingFilter(String attribute, String value) {
        this(attribute, PatternMatchingFilter.toRegex(value));
    }

    @Override
    protected boolean valueMatches(String value) {
        return this.m_pattern.matcher(value).matches();
    }

    @Override
    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("(");
        buf.append(this.getAttribute());
        buf.append("=");
        buf.append(PatternMatchingFilter.toFilterMatch(this.m_pattern));
        buf.append(")");
        return buf.toString();
    }

    public static Pattern toRegex(String value) {
        value = value.replace("\\*", "~~ESCAPED_STAR~~");
        value = value.replaceAll("\\\\(.)", "$1");
        value = PatternMatchingFilter.escapeAll(value, "\\");
        value = PatternMatchingFilter.escapeAll(value, "?+.[]()^${}");
        value = value.replace("*", ".*");
        value = value.replace("~~ESCAPED_STAR~~", "\\*");
        Pattern pattern = Pattern.compile(value);
        return pattern;
    }

    public static String toFilterMatch(Pattern pattern) {
        String value = pattern.pattern();
        value = value.replace("\\*", "~~ESCAPED_STAR~~");
        value = value.replace(".*", "*");
        value = value.replaceAll("\\\\(.)", "$1");
        value = PatternMatchingFilter.escapeAll(value, "\\");
        value = PatternMatchingFilter.escapeAll(value, "()");
        value = value.replace("~~ESCAPED_STAR~~", "\\*");
        return value;
    }

    public static String escapeAll(String input, String chars) {
        String output = input;
        for (int i = 0; i < chars.length(); ++i) {
            char ch = chars.charAt(i);
            output = output.replace(Character.toString(ch), "\\" + ch);
        }
        return output;
    }
}

