/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.core.db;

import javax.sql.DataSource;
import org.opennms.core.db.DataSourceFactory;
import org.opennms.core.resource.Vault;
import org.opennms.core.utils.ThreadCategory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;

public class DataSourceFactoryBean
implements FactoryBean<DataSource>,
InitializingBean,
DisposableBean {
    public DataSource getObject() throws Exception {
        return DataSourceFactory.getDataSource();
    }

    public Class<? extends DataSource> getObjectType() {
        return DataSourceFactory.getDataSource() == null ? DataSource.class : DataSourceFactory.getDataSource().getClass();
    }

    public boolean isSingleton() {
        return true;
    }

    public void afterPropertiesSet() throws Exception {
        DataSourceFactory.init();
        Vault.setDataSource((DataSource)DataSourceFactory.getInstance());
    }

    public void destroy() throws Exception {
        this.log().info("Closing DataSourceFactory!!!");
        DataSourceFactory.close();
    }

    private ThreadCategory log() {
        return ThreadCategory.getInstance(this.getClass());
    }
}

