/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.core.db;

import java.beans.PropertyVetoException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.lang.reflect.Constructor;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Logger;
import javax.sql.DataSource;
import org.apache.commons.io.IOUtils;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.ValidationException;
import org.opennms.core.db.C3P0ConnectionFactory;
import org.opennms.core.db.ClosableDataSource;
import org.opennms.core.utils.ConfigFileConstants;
import org.opennms.core.utils.LogUtils;
import org.opennms.core.xml.CastorUtils;
import org.opennms.netmgt.config.opennmsDataSources.ConnectionPool;
import org.opennms.netmgt.config.opennmsDataSources.DataSourceConfiguration;
import org.springframework.jdbc.datasource.LazyConnectionDataSourceProxy;

public final class DataSourceFactory
implements DataSource {
    private static final Class<?> DEFAULT_FACTORY_CLASS = C3P0ConnectionFactory.class;
    private static DataSource m_singleton = null;
    private static final Map<String, DataSource> m_dataSources = new ConcurrentHashMap<String, DataSource>();
    private static final List<Runnable> m_closers = new LinkedList<Runnable>();

    public static synchronized void init() throws IOException, MarshalException, ValidationException, ClassNotFoundException, PropertyVetoException, SQLException {
        if (!DataSourceFactory.isLoaded("opennms")) {
            DataSourceFactory.init("opennms");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void init(final String dsName) throws IOException, MarshalException, ValidationException, ClassNotFoundException, PropertyVetoException, SQLException {
        Constructor<?> constructor;
        if (DataSourceFactory.isLoaded(dsName)) {
            return;
        }
        String factoryClass = null;
        File cfgFile = ConfigFileConstants.getFile((int)ConfigFileConstants.OPENNMS_DATASOURCE_CONFIG_FILE_NAME);
        DataSourceConfiguration dsc = null;
        ConnectionPool connectionPool = null;
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(cfgFile);
            dsc = (DataSourceConfiguration)CastorUtils.unmarshal(DataSourceConfiguration.class, (InputStream)fileInputStream);
            connectionPool = dsc.getConnectionPool();
            if (connectionPool != null) {
                factoryClass = connectionPool.getFactory();
            }
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(fileInputStream);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)fileInputStream);
        String configPath = cfgFile.getPath();
        ClosableDataSource dataSource = null;
        String defaultClassName = DEFAULT_FACTORY_CLASS.getName();
        try {
            Class<?> clazz = Class.forName(factoryClass);
            constructor = clazz.getConstructor(String.class, String.class);
            dataSource = (ClosableDataSource)constructor.newInstance(configPath, dsName);
        }
        catch (Throwable t) {
            LogUtils.debugf(DataSourceFactory.class, (Throwable)t, (String)"Unable to load %s, falling back to the default dataSource (%s)", (Object[])new Object[]{factoryClass, defaultClassName});
            try {
                constructor = DEFAULT_FACTORY_CLASS.getConstructor(String.class, String.class);
                dataSource = (ClosableDataSource)constructor.newInstance(configPath, dsName);
            }
            catch (Throwable cause) {
                LogUtils.errorf(DataSourceFactory.class, (Throwable)cause, (String)"Unable to load %s.", (Object[])new Object[]{DEFAULT_FACTORY_CLASS.getName()});
                throw new SQLException("Unable to load " + defaultClassName + ".", cause);
            }
        }
        final ClosableDataSource runnableDs = dataSource;
        m_closers.add(new Runnable(){

            @Override
            public void run() {
                try {
                    runnableDs.close();
                }
                catch (Throwable cause) {
                    LogUtils.infof(DataSourceFactory.class, (Throwable)cause, (String)"Unable to close datasource %s.", (Object[])new Object[]{dsName});
                }
            }
        });
        if (connectionPool != null) {
            dataSource.setIdleTimeout(connectionPool.getIdleTimeout());
            dataSource.setLoginTimeout(connectionPool.getLoginTimeout());
            dataSource.setMinPool(connectionPool.getMinPool());
            dataSource.setMaxPool(connectionPool.getMaxPool());
            dataSource.setMaxSize(connectionPool.getMaxSize());
        }
        LazyConnectionDataSourceProxy lazyProxy = new LazyConnectionDataSourceProxy((DataSource)dataSource);
        DataSourceFactory.setInstance(dsName, (DataSource)lazyProxy);
    }

    private static synchronized boolean isLoaded(String dsName) {
        return m_dataSources.containsKey(dsName);
    }

    public static DataSource getInstance() {
        return DataSourceFactory.getInstance("opennms");
    }

    public static DataSource getInstance(String name) {
        DataSource dataSource = DataSourceFactory.getDataSource(name);
        if (dataSource == null) {
            throw new IllegalArgumentException("Unable to locate data source named " + name + ".  Does this need to be init'd?");
        }
        return dataSource;
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.getConnection("opennms");
    }

    public Connection getConnection(String dsName) throws SQLException {
        return DataSourceFactory.getDataSource(dsName).getConnection();
    }

    public static void setInstance(DataSource singleton) {
        m_singleton = singleton;
        DataSourceFactory.setInstance("opennms", singleton);
    }

    public static synchronized void setInstance(String dsName, DataSource singleton) {
        m_dataSources.put(dsName, singleton);
    }

    public static DataSource getDataSource() {
        return DataSourceFactory.getDataSource("opennms");
    }

    public static synchronized DataSource getDataSource(String dsName) {
        return m_dataSources.get(dsName);
    }

    @Override
    public Connection getConnection(String username, String password) throws SQLException {
        return this.getConnection();
    }

    @Override
    public PrintWriter getLogWriter() throws SQLException {
        return m_singleton.getLogWriter();
    }

    public PrintWriter getLogWriter(String dsName) throws SQLException {
        return DataSourceFactory.getDataSource(dsName).getLogWriter();
    }

    @Override
    public void setLogWriter(PrintWriter out) throws SQLException {
        this.setLogWriter("opennms", out);
    }

    public void setLogWriter(String dsName, PrintWriter out) throws SQLException {
        DataSourceFactory.getDataSource(dsName).setLogWriter(out);
    }

    @Override
    public void setLoginTimeout(int seconds) throws SQLException {
        this.setLoginTimeout("opennms", seconds);
    }

    public void setLoginTimeout(String dsName, int seconds) throws SQLException {
        DataSourceFactory.getDataSource(dsName).setLoginTimeout(seconds);
    }

    @Override
    public int getLoginTimeout() throws SQLException {
        return this.getLoginTimeout("opennms");
    }

    public int getLoginTimeout(String dsName) throws SQLException {
        return DataSourceFactory.getDataSource(dsName).getLoginTimeout();
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        throw new SQLFeatureNotSupportedException("getParentLogger not supported");
    }

    public static synchronized void close() throws SQLException {
        for (Runnable closer : m_closers) {
            closer.run();
        }
        m_closers.clear();
        m_dataSources.clear();
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return null;
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return false;
    }
}

