/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.core.db;

import java.beans.PropertyVetoException;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.apache.commons.io.IOUtils;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.ValidationException;
import org.opennms.core.db.ClosableDataSource;
import org.opennms.core.db.ConnectionFactoryUtil;
import org.opennms.core.utils.LogUtils;
import org.opennms.netmgt.config.opennmsDataSources.JdbcDataSource;

public abstract class BaseConnectionFactory
implements ClosableDataSource {
    protected BaseConnectionFactory(InputStream stream, String dsName) throws MarshalException, ValidationException, PropertyVetoException, SQLException {
        LogUtils.infof((Object)this, (String)"Setting up data source %s from input stream.", (Object[])new Object[]{dsName});
        JdbcDataSource ds = ConnectionFactoryUtil.marshalDataSourceFromConfig(stream, dsName);
        this.initializePool(ds);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected BaseConnectionFactory(String configFile, String dsName) throws IOException, MarshalException, ValidationException, PropertyVetoException, SQLException {
        FileInputStream fileInputStream = new FileInputStream(configFile);
        LogUtils.infof((Object)this, (String)"Setting up data sources from %s.", (Object[])new Object[]{configFile});
        try {
            JdbcDataSource ds = ConnectionFactoryUtil.marshalDataSourceFromConfig(fileInputStream, dsName);
            this.initializePool(ds);
        }
        finally {
            IOUtils.closeQuietly((InputStream)fileInputStream);
        }
    }

    protected abstract void initializePool(JdbcDataSource var1) throws SQLException;

    public abstract String getUrl();

    public abstract void setUrl(String var1);

    public abstract String getUser();

    public abstract void setUser(String var1);

    public abstract DataSource getDataSource();

    @Override
    public abstract int getLoginTimeout() throws SQLException;

    @Override
    public void close() throws SQLException {
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return null;
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return false;
    }

    protected static void validateJdbcUrl(String url) {
        try {
            if (url == null) {
                throw new IllegalArgumentException("Null JDBC URL");
            }
            if (url.length() == 0) {
                throw new IllegalArgumentException("Blank JDBC URL");
            }
            if (url.matches("\\$\\{.*\\}")) {
                throw new IllegalArgumentException("JDBC URL cannot contain replacement tokens");
            }
        }
        catch (IllegalArgumentException e) {
            LogUtils.errorf((Object)e, (Throwable)e, (String)"Invalid JDBC URL specified: %s", (Object[])new Object[]{e.getMessage()});
            throw e;
        }
    }
}

