/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.core.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import org.opennms.core.utils.AbstractTimeIntervalSequence;
import org.opennms.core.utils.OwnedInterval;
import org.opennms.core.utils.Owner;

public class OwnedIntervalSequence
extends AbstractTimeIntervalSequence<OwnedInterval> {
    public OwnedIntervalSequence() {
    }

    public OwnedIntervalSequence(OwnedInterval interval) {
        super(interval);
    }

    @Override
    protected Collection<OwnedInterval> combineIntervals(OwnedInterval currInterval, OwnedInterval newInterval) {
        Date midSegEnd;
        Date midSegStart;
        ArrayList<OwnedInterval> newIntervals = new ArrayList<OwnedInterval>(3);
        OwnedInterval firstSeg = null;
        OwnedInterval midSeg = null;
        OwnedInterval thirdSeg = null;
        if (currInterval.getStart().equals(newInterval.getStart())) {
            midSegStart = currInterval.getStart();
        } else if (currInterval.getStart().before(newInterval.getStart())) {
            firstSeg = new OwnedInterval(currInterval.getOwners(), currInterval.getStart(), newInterval.getStart());
            midSegStart = newInterval.getStart();
        } else {
            firstSeg = new OwnedInterval(newInterval.getOwners(), newInterval.getStart(), currInterval.getStart());
            midSegStart = currInterval.getStart();
        }
        if (currInterval.getEnd().equals(newInterval.getEnd())) {
            midSegEnd = currInterval.getEnd();
        } else if (currInterval.getEnd().after(newInterval.getEnd())) {
            thirdSeg = new OwnedInterval(currInterval.getOwners(), newInterval.getEnd(), currInterval.getEnd());
            midSegEnd = newInterval.getEnd();
        } else {
            thirdSeg = new OwnedInterval(newInterval.getOwners(), currInterval.getEnd(), newInterval.getEnd());
            midSegEnd = currInterval.getEnd();
        }
        midSeg = new OwnedInterval(currInterval.getOwners(), midSegStart, midSegEnd);
        midSeg.addOwners(newInterval.getOwners());
        if (firstSeg != null) {
            newIntervals.add(firstSeg);
        }
        if (midSeg != null) {
            newIntervals.add(midSeg);
        }
        if (thirdSeg != null) {
            newIntervals.add(thirdSeg);
        }
        return newIntervals;
    }

    @Override
    protected OwnedInterval createInterval(Date start, Date end) {
        return new OwnedInterval(start, end);
    }

    protected OwnedIntervalSequence createTail(OwnedInterval interval) {
        return new OwnedIntervalSequence(interval);
    }

    @Override
    protected Collection<OwnedInterval> separateIntervals(OwnedInterval origInterval, OwnedInterval removedInterval) {
        ArrayList<Owner> reducedOwners = new ArrayList<Owner>(origInterval.getOwners());
        reducedOwners.removeAll(removedInterval.getOwners());
        if (origInterval.isOwned() && removedInterval.isOwned() && ((Object)reducedOwners).equals(origInterval.getOwners())) {
            return Collections.singletonList(origInterval);
        }
        OwnedInterval firstSeg = null;
        OwnedInterval midSeg = null;
        OwnedInterval lastSeg = null;
        Date midSegStart = null;
        Date midSegEnd = null;
        if (origInterval.getStart().before(removedInterval.getStart())) {
            midSegStart = removedInterval.getStart();
            firstSeg = new OwnedInterval(origInterval.getOwners(), origInterval.getStart(), midSegStart);
        } else {
            midSegStart = origInterval.getStart();
        }
        if (removedInterval.getEnd().before(origInterval.getEnd())) {
            midSegEnd = removedInterval.getEnd();
            lastSeg = new OwnedInterval(origInterval.getOwners(), midSegEnd, origInterval.getEnd());
        } else {
            midSegEnd = origInterval.getEnd();
        }
        if (removedInterval.isOwned() && !reducedOwners.isEmpty()) {
            midSeg = new OwnedInterval(reducedOwners, midSegStart, midSegEnd);
        }
        ArrayList<OwnedInterval> newIntervals = new ArrayList<OwnedInterval>(3);
        if (firstSeg != null) {
            newIntervals.add(firstSeg);
        }
        if (midSeg != null) {
            newIntervals.add(midSeg);
        }
        if (lastSeg != null) {
            newIntervals.add(lastSeg);
        }
        return newIntervals;
    }
}

