/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.core.utils;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.opennms.core.utils.DBUtils;
import org.springframework.dao.DataRetrievalFailureException;

public abstract class JDBCTemplate {
    private DataSource m_db;
    private String m_sql;

    protected JDBCTemplate(DataSource db, String sql) {
        this.m_db = db;
        this.m_sql = sql;
    }

    public void execute(Object ... values) {
        try {
            this.doExecute(values);
        }
        catch (SQLException e) {
            String vals = this.argsToString(values);
            throw new DataRetrievalFailureException("Problem executing statement: " + this.m_sql + " with values " + vals, (Throwable)e);
        }
    }

    private String argsToString(Object[] values) {
        StringBuffer sb = new StringBuffer("[");
        for (int i = 0; i < values.length; ++i) {
            if (i != 0) {
                sb.append(", ");
            }
            sb.append(values[i]);
        }
        sb.append("]");
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doExecute(Object[] values) throws SQLException {
        DBUtils d = new DBUtils(this.getClass());
        try {
            Connection conn = this.m_db.getConnection();
            d.watch(conn);
            PreparedStatement stmt = conn.prepareStatement(this.m_sql);
            d.watch(stmt);
            for (int i = 0; i < values.length; ++i) {
                stmt.setObject(i + 1, values[i]);
            }
            this.executeStmt(stmt);
        }
        finally {
            d.cleanUp();
        }
    }

    public String reproduceStatement(Object[] values) {
        return this.m_sql + ": with vals " + this.argsToString(values);
    }

    abstract void executeStmt(PreparedStatement var1) throws SQLException;
}

