/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config.filter;

import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Marshaller;
import org.exolab.castor.xml.Unmarshaller;
import org.exolab.castor.xml.ValidationException;
import org.exolab.castor.xml.Validator;
import org.opennms.netmgt.config.filter.Table;
import org.xml.sax.ContentHandler;

public class DatabaseSchema
implements Serializable {
    private List<Table> _tableList = new ArrayList<Table>();

    public void addTable(Table vTable) throws IndexOutOfBoundsException {
        this._tableList.add(vTable);
    }

    public void addTable(int index, Table vTable) throws IndexOutOfBoundsException {
        this._tableList.add(index, vTable);
    }

    public Enumeration<Table> enumerateTable() {
        return Collections.enumeration(this._tableList);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DatabaseSchema) {
            DatabaseSchema temp = (DatabaseSchema)obj;
            if (this._tableList != null) {
                if (temp._tableList == null) {
                    return false;
                }
                if (!((Object)this._tableList).equals(temp._tableList)) {
                    return false;
                }
            } else if (temp._tableList != null) {
                return false;
            }
            return true;
        }
        return false;
    }

    public Table getTable(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._tableList.size()) {
            throw new IndexOutOfBoundsException("getTable: Index value '" + index + "' not in range [0.." + (this._tableList.size() - 1) + "]");
        }
        return this._tableList.get(index);
    }

    public Table[] getTable() {
        Table[] array = new Table[]{};
        return this._tableList.toArray(array);
    }

    public List<Table> getTableCollection() {
        return this._tableList;
    }

    public int getTableCount() {
        return this._tableList.size();
    }

    public int hashCode() {
        int result = 17;
        if (this._tableList != null) {
            result = 37 * result + ((Object)this._tableList).hashCode();
        }
        return result;
    }

    public boolean isValid() {
        try {
            this.validate();
        }
        catch (ValidationException vex) {
            return false;
        }
        return true;
    }

    public Iterator<Table> iterateTable() {
        return this._tableList.iterator();
    }

    public void marshal(Writer out) throws MarshalException, ValidationException {
        Marshaller.marshal((Object)this, (Writer)out);
    }

    public void marshal(ContentHandler handler) throws IOException, MarshalException, ValidationException {
        Marshaller.marshal((Object)this, (ContentHandler)handler);
    }

    public void removeAllTable() {
        this._tableList.clear();
    }

    public boolean removeTable(Table vTable) {
        boolean removed = this._tableList.remove(vTable);
        return removed;
    }

    public Table removeTableAt(int index) {
        Table obj = this._tableList.remove(index);
        return obj;
    }

    public void setTable(int index, Table vTable) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._tableList.size()) {
            throw new IndexOutOfBoundsException("setTable: Index value '" + index + "' not in range [0.." + (this._tableList.size() - 1) + "]");
        }
        this._tableList.set(index, vTable);
    }

    public void setTable(Table[] vTableArray) {
        this._tableList.clear();
        for (int i = 0; i < vTableArray.length; ++i) {
            this._tableList.add(vTableArray[i]);
        }
    }

    public void setTable(List<Table> vTableList) {
        this._tableList.clear();
        this._tableList.addAll(vTableList);
    }

    public void setTableCollection(List<Table> tableList) {
        this._tableList = tableList;
    }

    public static DatabaseSchema unmarshal(Reader reader) throws MarshalException, ValidationException {
        return (DatabaseSchema)Unmarshaller.unmarshal(DatabaseSchema.class, (Reader)reader);
    }

    public void validate() throws ValidationException {
        Validator validator = new Validator();
        validator.validate((Object)this);
    }
}

