/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config.datacollection;

import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Marshaller;
import org.exolab.castor.xml.Unmarshaller;
import org.exolab.castor.xml.ValidationException;
import org.exolab.castor.xml.Validator;
import org.opennms.core.xml.ValidateUsing;
import org.opennms.netmgt.config.datacollection.SnmpCollection;
import org.xml.sax.ContentHandler;

@XmlRootElement(name="datacollection-config", namespace="http://xmlns.opennms.org/xsd/config/datacollection")
@XmlAccessorType(value=XmlAccessType.NONE)
@ValidateUsing(value="datacollection-config.xsd")
public class DatacollectionConfig
implements Serializable {
    private static final long serialVersionUID = 9164334193148732102L;
    private static final SnmpCollection[] EMPTY_SNMPCOLLECTION_ARRAY = new SnmpCollection[0];
    private String m_rrdRepository;
    private List<SnmpCollection> m_snmpCollections = new ArrayList<SnmpCollection>();

    public void addSnmpCollection(SnmpCollection snmpCollection) throws IndexOutOfBoundsException {
        this.m_snmpCollections.add(snmpCollection);
    }

    public void addSnmpCollection(int index, SnmpCollection snmpCollection) throws IndexOutOfBoundsException {
        this.m_snmpCollections.add(index, snmpCollection);
    }

    public Enumeration<SnmpCollection> enumerateSnmpCollection() {
        return Collections.enumeration(this.m_snmpCollections);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DatacollectionConfig) {
            DatacollectionConfig temp = (DatacollectionConfig)obj;
            if (this.m_rrdRepository != null) {
                if (temp.m_rrdRepository == null) {
                    return false;
                }
                if (!this.m_rrdRepository.equals(temp.m_rrdRepository)) {
                    return false;
                }
            } else if (temp.m_rrdRepository != null) {
                return false;
            }
            if (this.m_snmpCollections != null) {
                if (temp.m_snmpCollections == null) {
                    return false;
                }
                if (!((Object)this.m_snmpCollections).equals(temp.m_snmpCollections)) {
                    return false;
                }
            } else if (temp.m_snmpCollections != null) {
                return false;
            }
            return true;
        }
        return false;
    }

    @XmlAttribute(name="rrdRepository")
    public String getRrdRepository() {
        return this.m_rrdRepository;
    }

    public SnmpCollection getSnmpCollection(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this.m_snmpCollections.size()) {
            throw new IndexOutOfBoundsException("getSnmpCollection: Index value '" + index + "' not in range [0.." + (this.m_snmpCollections.size() - 1) + "]");
        }
        return this.m_snmpCollections.get(index);
    }

    public SnmpCollection[] getSnmpCollection() {
        return this.m_snmpCollections.toArray(EMPTY_SNMPCOLLECTION_ARRAY);
    }

    @XmlElement(name="snmp-collection")
    public List<SnmpCollection> getSnmpCollectionCollection() {
        return this.m_snmpCollections;
    }

    public int getSnmpCollectionCount() {
        return this.m_snmpCollections.size();
    }

    public int hashCode() {
        int result = 17;
        if (this.m_rrdRepository != null) {
            result = 37 * result + this.m_rrdRepository.hashCode();
        }
        if (this.m_snmpCollections != null) {
            result = 37 * result + ((Object)this.m_snmpCollections).hashCode();
        }
        return result;
    }

    @Deprecated
    public boolean isValid() {
        try {
            this.validate();
        }
        catch (ValidationException vex) {
            return false;
        }
        return true;
    }

    public Iterator<SnmpCollection> iterateSnmpCollection() {
        return this.m_snmpCollections.iterator();
    }

    @Deprecated
    public void marshal(Writer out) throws MarshalException, ValidationException {
        Marshaller.marshal((Object)this, (Writer)out);
    }

    @Deprecated
    public void marshal(ContentHandler handler) throws IOException, MarshalException, ValidationException {
        Marshaller.marshal((Object)this, (ContentHandler)handler);
    }

    public void removeAllSnmpCollection() {
        this.m_snmpCollections.clear();
    }

    public boolean removeSnmpCollection(SnmpCollection snmpCollection) {
        return this.m_snmpCollections.remove(snmpCollection);
    }

    public SnmpCollection removeSnmpCollectionAt(int index) {
        return this.m_snmpCollections.remove(index);
    }

    public void setRrdRepository(String rrdRepository) {
        this.m_rrdRepository = rrdRepository.intern();
    }

    public void setSnmpCollection(int index, SnmpCollection snmpCollection) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this.m_snmpCollections.size()) {
            throw new IndexOutOfBoundsException("setSnmpCollection: Index value '" + index + "' not in range [0.." + (this.m_snmpCollections.size() - 1) + "]");
        }
        this.m_snmpCollections.set(index, snmpCollection);
    }

    public void setSnmpCollection(SnmpCollection[] snmpCollections) {
        this.m_snmpCollections.clear();
        for (int i = 0; i < snmpCollections.length; ++i) {
            this.m_snmpCollections.add(snmpCollections[i]);
        }
    }

    public void setSnmpCollection(List<SnmpCollection> snmpCollections) {
        if (this.m_snmpCollections == snmpCollections) {
            return;
        }
        this.m_snmpCollections.clear();
        this.m_snmpCollections.addAll(snmpCollections);
    }

    public void setSnmpCollectionCollection(List<SnmpCollection> snmpCollections) {
        this.m_snmpCollections = snmpCollections;
    }

    @Deprecated
    public static DatacollectionConfig unmarshal(Reader reader) throws MarshalException, ValidationException {
        return (DatacollectionConfig)Unmarshaller.unmarshal(DatacollectionConfig.class, (Reader)reader);
    }

    @Deprecated
    public void validate() throws ValidationException {
        new Validator().validate((Object)this);
    }
}

