/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.icmp.jni;

import java.io.IOException;
import java.net.DatagramPacket;
import java.util.Queue;
import org.opennms.core.utils.LogUtils;
import org.opennms.netmgt.icmp.jni.JniPingRequest;
import org.opennms.netmgt.icmp.jni.JniPingResponse;
import org.opennms.protocols.icmp.ICMPEchoPacket;
import org.opennms.protocols.icmp.IcmpSocket;
import org.opennms.protocols.rt.Messenger;

public class JniIcmpMessenger
implements Messenger<JniPingRequest, JniPingResponse> {
    private int m_pingerId;
    private IcmpSocket m_socket;

    public JniIcmpMessenger(int pingerId) throws IOException {
        this.m_pingerId = pingerId;
        this.m_socket = new IcmpSocket();
    }

    void processPackets(Queue<JniPingResponse> pendingReplies) {
        int pingerId = this.m_pingerId;
        while (true) {
            try {
                while (true) {
                    DatagramPacket packet;
                    JniPingResponse reply;
                    if (!(reply = JniIcmpMessenger.createPingResponse(packet = this.m_socket.receive())).isEchoReply() || reply.getIdentifier() != pingerId) {
                        continue;
                    }
                    pendingReplies.offer(reply);
                }
            }
            catch (IOException e) {
                LogUtils.errorf((Object)this, (Throwable)e, (String)"I/O Error occurred reading from ICMP Socket", (Object[])new Object[0]);
                continue;
            }
            catch (IllegalArgumentException e) {
                continue;
            }
            catch (IndexOutOfBoundsException e) {
                continue;
            }
            catch (Throwable e) {
                LogUtils.errorf((Object)this, (Throwable)e, (String)"Unexpected Exception processing reply packet!", (Object[])new Object[0]);
                continue;
            }
            break;
        }
    }

    public void sendRequest(JniPingRequest request) {
        request.send(this.m_socket);
    }

    public void start(final Queue<JniPingResponse> responseQueue) {
        Thread socketReader = new Thread("JNI-ICMP-" + this.m_pingerId + "-Socket-Reader"){

            @Override
            public void run() {
                try {
                    JniIcmpMessenger.this.processPackets(responseQueue);
                }
                catch (Throwable t) {
                    LogUtils.errorf((Object)this, (Throwable)t, (String)"Unexpected exception on Thread %s!", (Object[])new Object[]{this});
                }
            }
        };
        socketReader.setDaemon(true);
        socketReader.start();
    }

    public static JniPingResponse createPingResponse(DatagramPacket packet) {
        if (packet.getData().length != ICMPEchoPacket.getNetworkSize()) {
            throw new IllegalArgumentException("The packet is not the correct network size");
        }
        ICMPEchoPacket pkt = new ICMPEchoPacket(packet.getData());
        if (pkt.getReceivedTime() == 0L) {
            pkt.setReceivedTime();
        }
        return new JniPingResponse(packet.getAddress(), pkt);
    }
}

