/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.dao.support;

import java.util.ArrayList;
import java.util.List;
import org.opennms.core.utils.ReplaceAllOperation;
import org.opennms.core.utils.ReplaceFirstOperation;
import org.opennms.core.utils.StringReplaceOperation;
import org.opennms.netmgt.config.collector.CollectionResource;
import org.opennms.netmgt.config.collector.CollectionSetVisitor;
import org.opennms.netmgt.config.datacollection.Parameter;
import org.opennms.netmgt.dao.support.IndexStorageStrategy;
import org.opennms.netmgt.dao.support.StringAttributeVisitor;

public class SiblingColumnStorageStrategy
extends IndexStorageStrategy {
    private static final String PARAM_SIBLING_COLUMN_NAME = "sibling-column-name";
    private String m_siblingColumnName;
    private static final String PARAM_REPLACE_FIRST = "replace-first";
    private static final String PARAM_REPLACE_ALL = "replace-all";
    private List<StringReplaceOperation> m_replaceOps = new ArrayList<StringReplaceOperation>();

    @Override
    public String getResourceNameFromIndex(CollectionResource resource) {
        this.log().debug("Finding the value of sibling column " + this.m_siblingColumnName + " for resource " + resource.getInstance() + "@" + resource.getParent());
        StringAttributeVisitor visitor = new StringAttributeVisitor(this.m_siblingColumnName);
        resource.visit((CollectionSetVisitor)visitor);
        String value = visitor.getValue() != null ? visitor.getValue() : resource.getInstance();
        String name = value.replaceAll("[^\\x00-\\x7F]", "").replaceAll("/", "-");
        for (StringReplaceOperation op : this.m_replaceOps) {
            this.log().debug("Doing string replacement on instance name '" + name + "' using " + op);
            name = op.replace(name);
        }
        this.log().debug("Inbound instance name was '" + resource.getInstance() + "', outbound was '" + ("".equals(name) ? resource.getInstance() : name) + "'");
        return "".equals(name) ? resource.getInstance() : name;
    }

    @Override
    public void setParameters(List<Parameter> parameterCollection) throws IllegalArgumentException {
        if (parameterCollection == null) {
            String msg = "Got a null parameter list, but need one containing a 'sibling-column-name' parameter.";
            this.log().fatal("Got a null parameter list, but need one containing a 'sibling-column-name' parameter.");
            throw new IllegalArgumentException("Got a null parameter list, but need one containing a 'sibling-column-name' parameter.");
        }
        for (Parameter param : parameterCollection) {
            if (PARAM_SIBLING_COLUMN_NAME.equals(param.getKey())) {
                this.m_siblingColumnName = param.getValue();
                continue;
            }
            if (PARAM_REPLACE_FIRST.equals(param.getKey())) {
                this.m_replaceOps.add((StringReplaceOperation)new ReplaceFirstOperation(param.getValue()));
                continue;
            }
            if (PARAM_REPLACE_ALL.equals(param.getKey())) {
                this.m_replaceOps.add((StringReplaceOperation)new ReplaceAllOperation(param.getValue()));
                continue;
            }
            if (param.getKey().equals("sibling-column-oid")) {
                String msg = "The parameter 'sibling-column-oid' has been deprecated and it is no longer used. You should configure 'sibling-column-name' instead. For this parameter, you should use the name of any MibObj defined as string for the same resource type.";
                this.log().error("The parameter 'sibling-column-oid' has been deprecated and it is no longer used. You should configure 'sibling-column-name' instead. For this parameter, you should use the name of any MibObj defined as string for the same resource type.");
                throw new IllegalArgumentException("The parameter 'sibling-column-oid' has been deprecated and it is no longer used. You should configure 'sibling-column-name' instead. For this parameter, you should use the name of any MibObj defined as string for the same resource type.");
            }
            this.log().warn("Encountered unsupported parameter key=\"" + param.getKey() + "\". Can accept: " + PARAM_SIBLING_COLUMN_NAME + ", " + PARAM_REPLACE_FIRST + ", " + PARAM_REPLACE_ALL);
        }
        if (this.m_siblingColumnName == null) {
            String msg = "The provided parameter list must contain a 'sibling-column-name' parameter.";
            this.log().error("The provided parameter list must contain a 'sibling-column-name' parameter.");
            throw new IllegalArgumentException("The provided parameter list must contain a 'sibling-column-name' parameter.");
        }
    }
}

